<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AtualizarVeiculoSensor StructType
 * Meta information extracted from the WSDL
 * - type: tns:AtualizarVeiculoSensor
 * @subpackage Structs
 */
class AtualizarVeiculoSensor extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdCadSensor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCadSensor;
    /**
     * The Descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Descricao;
    /**
     * Constructor method for AtualizarVeiculoSensor
     * @uses AtualizarVeiculoSensor::setUsuario()
     * @uses AtualizarVeiculoSensor::setSenha()
     * @uses AtualizarVeiculoSensor::setIdCadSensor()
     * @uses AtualizarVeiculoSensor::setDescricao()
     * @param string $usuario
     * @param string $senha
     * @param int $idCadSensor
     * @param string $descricao
     */
    public function __construct($usuario = null, $senha = null, $idCadSensor = null, $descricao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdCadSensor($idCadSensor)
            ->setDescricao($descricao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\AtualizarVeiculoSensor
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\AtualizarVeiculoSensor
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdCadSensor value
     * @return int|null
     */
    public function getIdCadSensor()
    {
        return $this->IdCadSensor;
    }
    /**
     * Set IdCadSensor value
     * @param int $idCadSensor
     * @return \StructType\AtualizarVeiculoSensor
     */
    public function setIdCadSensor($idCadSensor = null)
    {
        // validation for constraint: int
        if (!is_null($idCadSensor) && !(is_int($idCadSensor) || ctype_digit($idCadSensor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCadSensor, true), gettype($idCadSensor)), __LINE__);
        }
        $this->IdCadSensor = $idCadSensor;
        return $this;
    }
    /**
     * Get Descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->Descricao;
    }
    /**
     * Set Descricao value
     * @param string $descricao
     * @return \StructType\AtualizarVeiculoSensor
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->Descricao = $descricao;
        return $this;
    }
}
