<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlterarIntervaloPosicao StructType
 * Meta information extracted from the WSDL
 * - type: tns:AlterarIntervaloPosicao
 * @subpackage Structs
 */
class AlterarIntervaloPosicao extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdTerminal;
    /**
     * The Intervalo_DPLUS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Intervalo_DPLUS;
    /**
     * The Intervalo_IP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Intervalo_IP;
    /**
     * Constructor method for AlterarIntervaloPosicao
     * @uses AlterarIntervaloPosicao::setUsuario()
     * @uses AlterarIntervaloPosicao::setSenha()
     * @uses AlterarIntervaloPosicao::setIdTerminal()
     * @uses AlterarIntervaloPosicao::setIntervalo_DPLUS()
     * @uses AlterarIntervaloPosicao::setIntervalo_IP()
     * @param string $usuario
     * @param string $senha
     * @param int $idTerminal
     * @param int $intervalo_DPLUS
     * @param int $intervalo_IP
     */
    public function __construct($usuario = null, $senha = null, $idTerminal = null, $intervalo_DPLUS = null, $intervalo_IP = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdTerminal($idTerminal)
            ->setIntervalo_DPLUS($intervalo_DPLUS)
            ->setIntervalo_IP($intervalo_IP);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\AlterarIntervaloPosicao
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\AlterarIntervaloPosicao
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdTerminal value
     * @return int|null
     */
    public function getIdTerminal()
    {
        return $this->IdTerminal;
    }
    /**
     * Set IdTerminal value
     * @param int $idTerminal
     * @return \StructType\AlterarIntervaloPosicao
     */
    public function setIdTerminal($idTerminal = null)
    {
        // validation for constraint: int
        if (!is_null($idTerminal) && !(is_int($idTerminal) || ctype_digit($idTerminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTerminal, true), gettype($idTerminal)), __LINE__);
        }
        $this->IdTerminal = $idTerminal;
        return $this;
    }
    /**
     * Get Intervalo_DPLUS value
     * @return int|null
     */
    public function getIntervalo_DPLUS()
    {
        return $this->Intervalo_DPLUS;
    }
    /**
     * Set Intervalo_DPLUS value
     * @param int $intervalo_DPLUS
     * @return \StructType\AlterarIntervaloPosicao
     */
    public function setIntervalo_DPLUS($intervalo_DPLUS = null)
    {
        // validation for constraint: int
        if (!is_null($intervalo_DPLUS) && !(is_int($intervalo_DPLUS) || ctype_digit($intervalo_DPLUS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intervalo_DPLUS, true), gettype($intervalo_DPLUS)), __LINE__);
        }
        $this->Intervalo_DPLUS = $intervalo_DPLUS;
        return $this;
    }
    /**
     * Get Intervalo_IP value
     * @return int|null
     */
    public function getIntervalo_IP()
    {
        return $this->Intervalo_IP;
    }
    /**
     * Set Intervalo_IP value
     * @param int $intervalo_IP
     * @return \StructType\AlterarIntervaloPosicao
     */
    public function setIntervalo_IP($intervalo_IP = null)
    {
        // validation for constraint: int
        if (!is_null($intervalo_IP) && !(is_int($intervalo_IP) || ctype_digit($intervalo_IP))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intervalo_IP, true), gettype($intervalo_IP)), __LINE__);
        }
        $this->Intervalo_IP = $intervalo_IP;
        return $this;
    }
}
