<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pede ServiceType
 * @subpackage Services
 */
class Pede extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PedePosicaoAvulsa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PedePosicaoAvulsa $parameters
     * @return \StructType\PedePosicaoAvulsaResponse|bool
     */
    public function PedePosicaoAvulsa(\StructType\PedePosicaoAvulsa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PedePosicaoAvulsa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PedeHistorico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PedeHistorico $parameters
     * @return \StructType\PedeHistoricoResponse|bool
     */
    public function PedeHistorico(\StructType\PedeHistorico $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PedeHistorico($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PedeHistoricoResponse|\StructType\PedePosicaoAvulsaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
