<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Novo ServiceType
 * @subpackage Services
 */
class Novo extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NovoGrupoMensagemFormatada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NovoGrupoMensagemFormatada $parameters
     * @return \StructType\NovoGrupoMensagemFormatadaResponse|bool
     */
    public function NovoGrupoMensagemFormatada(\StructType\NovoGrupoMensagemFormatada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NovoGrupoMensagemFormatada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NovoMensagemFormatada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NovoMensagemFormatada $parameters
     * @return \StructType\NovoMensagemFormatadaResponse|bool
     */
    public function NovoMensagemFormatada(\StructType\NovoMensagemFormatada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NovoMensagemFormatada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NovoMensagemFormatadaXMLItens
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NovoMensagemFormatadaXMLItens $parameters
     * @return \StructType\NovoMensagemFormatadaXMLItensResponse|bool
     */
    public function NovoMensagemFormatadaXMLItens(\StructType\NovoMensagemFormatadaXMLItens $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NovoMensagemFormatadaXMLItens($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NovoMensagemFormatadaItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NovoMensagemFormatadaItem $parameters
     * @return \StructType\NovoMensagemFormatadaItemResponse|bool
     */
    public function NovoMensagemFormatadaItem(\StructType\NovoMensagemFormatadaItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NovoMensagemFormatadaItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NovoParametroVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NovoParametroVeiculo $parameters
     * @return \StructType\NovoParametroVeiculoResponse|bool
     */
    public function NovoParametroVeiculo(\StructType\NovoParametroVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NovoParametroVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NovoPerfilParametroVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NovoPerfilParametroVeiculo $parameters
     * @return \StructType\NovoPerfilParametroVeiculoResponse|bool
     */
    public function NovoPerfilParametroVeiculo(\StructType\NovoPerfilParametroVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NovoPerfilParametroVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NovoGrupoMensagemFormatadaResponse|\StructType\NovoMensagemFormatadaItemResponse|\StructType\NovoMensagemFormatadaResponse|\StructType\NovoMensagemFormatadaXMLItensResponse|\StructType\NovoParametroVeiculoResponse|\StructType\NovoPerfilParametroVeiculoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
