<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mudar ServiceType
 * @subpackage Services
 */
class Mudar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MudarGrupoDoAlvo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MudarGrupoDoAlvo $parameters
     * @return \StructType\MudarGrupoDoAlvoResponse|bool
     */
    public function MudarGrupoDoAlvo(\StructType\MudarGrupoDoAlvo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MudarGrupoDoAlvo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MudarGrupoDaRota
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MudarGrupoDaRota $parameters
     * @return \StructType\MudarGrupoDaRotaResponse|bool
     */
    public function MudarGrupoDaRota(\StructType\MudarGrupoDaRota $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MudarGrupoDaRota($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MudarGrupoDaCerca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MudarGrupoDaCerca $parameters
     * @return \StructType\MudarGrupoDaCercaResponse|bool
     */
    public function MudarGrupoDaCerca(\StructType\MudarGrupoDaCerca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MudarGrupoDaCerca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MudarGrupoDaCercaResponse|\StructType\MudarGrupoDaRotaResponse|\StructType\MudarGrupoDoAlvoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
