<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Listar ServiceType
 * @subpackage Services
 */
class Listar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListarAlvos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarAlvos $parameters
     * @return \StructType\ListarAlvosResponse|bool
     */
    public function ListarAlvos(\StructType\ListarAlvos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarAlvos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarAlvosIndexados
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarAlvosIndexados $parameters
     * @return \StructType\ListarAlvosIndexadosResponse|bool
     */
    public function ListarAlvosIndexados(\StructType\ListarAlvosIndexados $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarAlvosIndexados($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarAlvoAssociadoVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarAlvoAssociadoVeiculo $parameters
     * @return \StructType\ListarAlvoAssociadoVeiculoResponse|bool
     */
    public function ListarAlvoAssociadoVeiculo(\StructType\ListarAlvoAssociadoVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarAlvoAssociadoVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarGrupoAlvo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoAlvo $parameters
     * @return \StructType\ListarGrupoAlvoResponse|bool
     */
    public function ListarGrupoAlvo(\StructType\ListarGrupoAlvo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoAlvo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarGrupoMensagemFormatadaDetalhe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoMensagemFormatadaDetalhe $parameters
     * @return \StructType\ListarGrupoMensagemFormatadaDetalheResponse|bool
     */
    public function ListarGrupoMensagemFormatadaDetalhe(\StructType\ListarGrupoMensagemFormatadaDetalhe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoMensagemFormatadaDetalhe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgAtuadoresByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgAtuadoresByIdSequencia $parameters
     * @return \StructType\ListarCfgAtuadoresByIdSequenciaResponse|bool
     */
    public function ListarCfgAtuadoresByIdSequencia(\StructType\ListarCfgAtuadoresByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgAtuadoresByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgAtuadoresByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgAtuadoresByIdCliente $parameters
     * @return \StructType\ListarCfgAtuadoresByIdClienteResponse|bool
     */
    public function ListarCfgAtuadoresByIdCliente(\StructType\ListarCfgAtuadoresByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgAtuadoresByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgExcecaoByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgExcecaoByIdSequencia $parameters
     * @return \StructType\ListarCfgExcecaoByIdSequenciaResponse|bool
     */
    public function ListarCfgExcecaoByIdSequencia(\StructType\ListarCfgExcecaoByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgExcecaoByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgExcecaoByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgExcecaoByIdCliente $parameters
     * @return \StructType\ListarCfgExcecaoByIdClienteResponse|bool
     */
    public function ListarCfgExcecaoByIdCliente(\StructType\ListarCfgExcecaoByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgExcecaoByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgInterativoByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgInterativoByIdSequencia $parameters
     * @return \StructType\ListarCfgInterativoByIdSequenciaResponse|bool
     */
    public function ListarCfgInterativoByIdSequencia(\StructType\ListarCfgInterativoByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgInterativoByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgInterativoByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgInterativoByIdCliente $parameters
     * @return \StructType\ListarCfgInterativoByIdClienteResponse|bool
     */
    public function ListarCfgInterativoByIdCliente(\StructType\ListarCfgInterativoByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgInterativoByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgLogByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgLogByIdSequencia $parameters
     * @return \StructType\ListarCfgLogByIdSequenciaResponse|bool
     */
    public function ListarCfgLogByIdSequencia(\StructType\ListarCfgLogByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgLogByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgLogByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgLogByIdCliente $parameters
     * @return \StructType\ListarCfgLogByIdClienteResponse|bool
     */
    public function ListarCfgLogByIdCliente(\StructType\ListarCfgLogByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgLogByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgOpcoesSeByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgOpcoesSeByIdSequencia $parameters
     * @return \StructType\ListarCfgOpcoesSeByIdSequenciaResponse|bool
     */
    public function ListarCfgOpcoesSeByIdSequencia(\StructType\ListarCfgOpcoesSeByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgOpcoesSeByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgOpcoesSeByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgOpcoesSeByIdCliente $parameters
     * @return \StructType\ListarCfgOpcoesSeByIdClienteResponse|bool
     */
    public function ListarCfgOpcoesSeByIdCliente(\StructType\ListarCfgOpcoesSeByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgOpcoesSeByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgOpcoesSegByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgOpcoesSegByIdSequencia $parameters
     * @return \StructType\ListarCfgOpcoesSegByIdSequenciaResponse|bool
     */
    public function ListarCfgOpcoesSegByIdSequencia(\StructType\ListarCfgOpcoesSegByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgOpcoesSegByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgOpcoesSegByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgOpcoesSegByIdCliente $parameters
     * @return \StructType\ListarCfgOpcoesSegByIdClienteResponse|bool
     */
    public function ListarCfgOpcoesSegByIdCliente(\StructType\ListarCfgOpcoesSegByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgOpcoesSegByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarCfgOpcoesSegByIdClientePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgOpcoesSegByIdClientePerfil $parameters
     * @return \StructType\ListarCfgOpcoesSegByIdClientePerfilResponse|bool
     */
    public function ListarCfgOpcoesSegByIdClientePerfil(\StructType\ListarCfgOpcoesSegByIdClientePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgOpcoesSegByIdClientePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgSenhasByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgSenhasByIdSequencia $parameters
     * @return \StructType\ListarCfgSenhasByIdSequenciaResponse|bool
     */
    public function ListarCfgSenhasByIdSequencia(\StructType\ListarCfgSenhasByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgSenhasByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgSenhasByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgSenhasByIdCliente $parameters
     * @return \StructType\ListarCfgSenhasByIdClienteResponse|bool
     */
    public function ListarCfgSenhasByIdCliente(\StructType\ListarCfgSenhasByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgSenhasByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgTemperaturaByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgTemperaturaByIdSequencia $parameters
     * @return \StructType\ListarCfgTemperaturaByIdSequenciaResponse|bool
     */
    public function ListarCfgTemperaturaByIdSequencia(\StructType\ListarCfgTemperaturaByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgTemperaturaByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgTemperaturaByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgTemperaturaByIdCliente $parameters
     * @return \StructType\ListarCfgTemperaturaByIdClienteResponse|bool
     */
    public function ListarCfgTemperaturaByIdCliente(\StructType\ListarCfgTemperaturaByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgTemperaturaByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgTransicaoByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgTransicaoByIdSequencia $parameters
     * @return \StructType\ListarCfgTransicaoByIdSequenciaResponse|bool
     */
    public function ListarCfgTransicaoByIdSequencia(\StructType\ListarCfgTransicaoByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgTransicaoByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgTransicaoByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgTransicaoByIdCliente $parameters
     * @return \StructType\ListarCfgTransicaoByIdClienteResponse|bool
     */
    public function ListarCfgTransicaoByIdCliente(\StructType\ListarCfgTransicaoByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgTransicaoByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgTransicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgTransicao $parameters
     * @return \StructType\ListarCfgTransicaoResponse|bool
     */
    public function ListarCfgTransicao(\StructType\ListarCfgTransicao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgTransicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgTransmissaoByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgTransmissaoByIdSequencia $parameters
     * @return \StructType\ListarCfgTransmissaoByIdSequenciaResponse|bool
     */
    public function ListarCfgTransmissaoByIdSequencia(\StructType\ListarCfgTransmissaoByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgTransmissaoByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgTransmissaoByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgTransmissaoByIdCliente $parameters
     * @return \StructType\ListarCfgTransmissaoByIdClienteResponse|bool
     */
    public function ListarCfgTransmissaoByIdCliente(\StructType\ListarCfgTransmissaoByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgTransmissaoByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarPerfilConfiguracaoByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarPerfilConfiguracaoByIdCliente $parameters
     * @return \StructType\ListarPerfilConfiguracaoByIdClienteResponse|bool
     */
    public function ListarPerfilConfiguracaoByIdCliente(\StructType\ListarPerfilConfiguracaoByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarPerfilConfiguracaoByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarOperacaoByCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarOperacaoByCliente $parameters
     * @return \StructType\ListarOperacaoByClienteResponse|bool
     */
    public function ListarOperacaoByCliente(\StructType\ListarOperacaoByCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarOperacaoByCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarItensOperacaoByOperacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarItensOperacaoByOperacao $parameters
     * @return \StructType\ListarItensOperacaoByOperacaoResponse|bool
     */
    public function ListarItensOperacaoByOperacao(\StructType\ListarItensOperacaoByOperacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarItensOperacaoByOperacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarGrupoCercas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoCercas $parameters
     * @return \StructType\ListarGrupoCercasResponse|bool
     */
    public function ListarGrupoCercas(\StructType\ListarGrupoCercas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoCercas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCercas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCercas $parameters
     * @return \StructType\ListarCercasResponse|bool
     */
    public function ListarCercas(\StructType\ListarCercas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCercas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCercasIndexado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCercasIndexado $parameters
     * @return \StructType\ListarCercasIndexadoResponse|bool
     */
    public function ListarCercasIndexado(\StructType\ListarCercasIndexado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCercasIndexado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgAtuadoresByIdTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgAtuadoresByIdTerminal $parameters
     * @return \StructType\ListarCfgAtuadoresByIdTerminalResponse|bool
     */
    public function ListarCfgAtuadoresByIdTerminal(\StructType\ListarCfgAtuadoresByIdTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgAtuadoresByIdTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgInterativoByIdTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgInterativoByIdTerminal $parameters
     * @return \StructType\ListarCfgInterativoByIdTerminalResponse|bool
     */
    public function ListarCfgInterativoByIdTerminal(\StructType\ListarCfgInterativoByIdTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgInterativoByIdTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgLogByIdTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgLogByIdTerminal $parameters
     * @return \StructType\ListarCfgLogByIdTerminalResponse|bool
     */
    public function ListarCfgLogByIdTerminal(\StructType\ListarCfgLogByIdTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgLogByIdTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgOpcoesSeByIdTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgOpcoesSeByIdTerminal $parameters
     * @return \StructType\ListarCfgOpcoesSeByIdTerminalResponse|bool
     */
    public function ListarCfgOpcoesSeByIdTerminal(\StructType\ListarCfgOpcoesSeByIdTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgOpcoesSeByIdTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgOpcoesSegByIdTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgOpcoesSegByIdTerminal $parameters
     * @return \StructType\ListarCfgOpcoesSegByIdTerminalResponse|bool
     */
    public function ListarCfgOpcoesSegByIdTerminal(\StructType\ListarCfgOpcoesSegByIdTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgOpcoesSegByIdTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgSenhasByIdTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgSenhasByIdTerminal $parameters
     * @return \StructType\ListarCfgSenhasByIdTerminalResponse|bool
     */
    public function ListarCfgSenhasByIdTerminal(\StructType\ListarCfgSenhasByIdTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgSenhasByIdTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgTemperaturaByIdTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgTemperaturaByIdTerminal $parameters
     * @return \StructType\ListarCfgTemperaturaByIdTerminalResponse|bool
     */
    public function ListarCfgTemperaturaByIdTerminal(\StructType\ListarCfgTemperaturaByIdTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgTemperaturaByIdTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgTransmissaoByIdTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgTransmissaoByIdTerminal $parameters
     * @return \StructType\ListarCfgTransmissaoByIdTerminalResponse|bool
     */
    public function ListarCfgTransmissaoByIdTerminal(\StructType\ListarCfgTransmissaoByIdTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgTransmissaoByIdTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgExcecaoByIdTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgExcecaoByIdTerminal $parameters
     * @return \StructType\ListarCfgExcecaoByIdTerminalResponse|bool
     */
    public function ListarCfgExcecaoByIdTerminal(\StructType\ListarCfgExcecaoByIdTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgExcecaoByIdTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarGrupoRotas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoRotas $parameters
     * @return \StructType\ListarGrupoRotasResponse|bool
     */
    public function ListarGrupoRotas(\StructType\ListarGrupoRotas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoRotas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarRotas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarRotas $parameters
     * @return \StructType\ListarRotasResponse|bool
     */
    public function ListarRotas(\StructType\ListarRotas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarRotas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarRotasIndexado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarRotasIndexado $parameters
     * @return \StructType\ListarRotasIndexadoResponse|bool
     */
    public function ListarRotasIndexado(\StructType\ListarRotasIndexado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarRotasIndexado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarModTransicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarModTransicao $parameters
     * @return \StructType\ListarModTransicaoResponse|bool
     */
    public function ListarModTransicao(\StructType\ListarModTransicao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarModTransicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarTodosModTransicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTodosModTransicao $parameters
     * @return \StructType\ListarTodosModTransicaoResponse|bool
     */
    public function ListarTodosModTransicao(\StructType\ListarTodosModTransicao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTodosModTransicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarMensagemPredefinida
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarMensagemPredefinida $parameters
     * @return \StructType\ListarMensagemPredefinidaResponse|bool
     */
    public function ListarMensagemPredefinida(\StructType\ListarMensagemPredefinida $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarMensagemPredefinida($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarTodosMensagemPredefinida
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTodosMensagemPredefinida $parameters
     * @return \StructType\ListarTodosMensagemPredefinidaResponse|bool
     */
    public function ListarTodosMensagemPredefinida(\StructType\ListarTodosMensagemPredefinida $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTodosMensagemPredefinida($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarTodosMensagemPredefinidaAssociada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTodosMensagemPredefinidaAssociada $parameters
     * @return \StructType\ListarTodosMensagemPredefinidaAssociadaResponse|bool
     */
    public function ListarTodosMensagemPredefinidaAssociada(\StructType\ListarTodosMensagemPredefinidaAssociada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTodosMensagemPredefinidaAssociada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarGrupoMensagemFormatada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoMensagemFormatada $parameters
     * @return \StructType\ListarGrupoMensagemFormatadaResponse|bool
     */
    public function ListarGrupoMensagemFormatada(\StructType\ListarGrupoMensagemFormatada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoMensagemFormatada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarTodosGrupoMensagemFormatada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTodosGrupoMensagemFormatada $parameters
     * @return \StructType\ListarTodosGrupoMensagemFormatadaResponse|bool
     */
    public function ListarTodosGrupoMensagemFormatada(\StructType\ListarTodosGrupoMensagemFormatada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTodosGrupoMensagemFormatada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarMensagemFormatada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarMensagemFormatada $parameters
     * @return \StructType\ListarMensagemFormatadaResponse|bool
     */
    public function ListarMensagemFormatada(\StructType\ListarMensagemFormatada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarMensagemFormatada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarTodosMensagemFormatada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTodosMensagemFormatada $parameters
     * @return \StructType\ListarTodosMensagemFormatadaResponse|bool
     */
    public function ListarTodosMensagemFormatada(\StructType\ListarTodosMensagemFormatada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTodosMensagemFormatada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarParametroVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarParametroVeiculo $parameters
     * @return \StructType\ListarParametroVeiculoResponse|bool
     */
    public function ListarParametroVeiculo(\StructType\ListarParametroVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarParametroVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarParametrosVeiculoSecao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarParametrosVeiculoSecao $parameters
     * @return \StructType\ListarParametrosVeiculoSecaoResponse|bool
     */
    public function ListarParametrosVeiculoSecao(\StructType\ListarParametrosVeiculoSecao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarParametrosVeiculoSecao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarPerfilParametroVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarPerfilParametroVeiculo $parameters
     * @return \StructType\ListarPerfilParametroVeiculoResponse|bool
     */
    public function ListarPerfilParametroVeiculo(\StructType\ListarPerfilParametroVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarPerfilParametroVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCercaAssociadoVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCercaAssociadoVeiculo $parameters
     * @return \StructType\ListarCercaAssociadoVeiculoResponse|bool
     */
    public function ListarCercaAssociadoVeiculo(\StructType\ListarCercaAssociadoVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCercaAssociadoVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarRotaAssociadoVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarRotaAssociadoVeiculo $parameters
     * @return \StructType\ListarRotaAssociadoVeiculoResponse|bool
     */
    public function ListarRotaAssociadoVeiculo(\StructType\ListarRotaAssociadoVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarRotaAssociadoVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarCfgMultiplosSensoresByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgMultiplosSensoresByIdSequencia $parameters
     * @return \StructType\ListarCfgMultiplosSensoresByIdSequenciaResponse|bool
     */
    public function ListarCfgMultiplosSensoresByIdSequencia(\StructType\ListarCfgMultiplosSensoresByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgMultiplosSensoresByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarCfgMultiplosSensoresByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgMultiplosSensoresByIdCliente $parameters
     * @return \StructType\ListarCfgMultiplosSensoresByIdClienteResponse|bool
     */
    public function ListarCfgMultiplosSensoresByIdCliente(\StructType\ListarCfgMultiplosSensoresByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgMultiplosSensoresByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarCfgMultiplosSensoresByIdTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgMultiplosSensoresByIdTerminal $parameters
     * @return \StructType\ListarCfgMultiplosSensoresByIdTerminalResponse|bool
     */
    public function ListarCfgMultiplosSensoresByIdTerminal(\StructType\ListarCfgMultiplosSensoresByIdTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgMultiplosSensoresByIdTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarItensCfgModTransicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarItensCfgModTransicao $parameters
     * @return \StructType\ListarItensCfgModTransicaoResponse|bool
     */
    public function ListarItensCfgModTransicao(\StructType\ListarItensCfgModTransicao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarItensCfgModTransicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarMensagemFormatadaAssociadaOrigem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarMensagemFormatadaAssociadaOrigem $parameters
     * @return \StructType\ListarMensagemFormatadaAssociadaOrigemResponse|bool
     */
    public function ListarMensagemFormatadaAssociadaOrigem(\StructType\ListarMensagemFormatadaAssociadaOrigem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarMensagemFormatadaAssociadaOrigem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarMensagemFormatadaAssociadaDestino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarMensagemFormatadaAssociadaDestino $parameters
     * @return \StructType\ListarMensagemFormatadaAssociadaDestinoResponse|bool
     */
    public function ListarMensagemFormatadaAssociadaDestino(\StructType\ListarMensagemFormatadaAssociadaDestino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarMensagemFormatadaAssociadaDestino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarMensagemFormatadaEnviada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarMensagemFormatadaEnviada $parameters
     * @return \StructType\ListarMensagemFormatadaEnviadaResponse|bool
     */
    public function ListarMensagemFormatadaEnviada(\StructType\ListarMensagemFormatadaEnviada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarMensagemFormatadaEnviada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarFuncoesProgramadas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarFuncoesProgramadas $parameters
     * @return \StructType\ListarFuncoesProgramadasResponse|bool
     */
    public function ListarFuncoesProgramadas(\StructType\ListarFuncoesProgramadas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarFuncoesProgramadas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgUmidadeByIdSequencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgUmidadeByIdSequencia $parameters
     * @return \StructType\ListarCfgUmidadeByIdSequenciaResponse|bool
     */
    public function ListarCfgUmidadeByIdSequencia(\StructType\ListarCfgUmidadeByIdSequencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgUmidadeByIdSequencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgUmidadeByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgUmidadeByIdCliente $parameters
     * @return \StructType\ListarCfgUmidadeByIdClienteResponse|bool
     */
    public function ListarCfgUmidadeByIdCliente(\StructType\ListarCfgUmidadeByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgUmidadeByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgUmidadeByIdTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgUmidadeByIdTerminal $parameters
     * @return \StructType\ListarCfgUmidadeByIdTerminalResponse|bool
     */
    public function ListarCfgUmidadeByIdTerminal(\StructType\ListarCfgUmidadeByIdTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgUmidadeByIdTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarGrupoAlvoAssociadoVeiculoDetalhe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoAlvoAssociadoVeiculoDetalhe $parameters
     * @return \StructType\ListarGrupoAlvoAssociadoVeiculoDetalheResponse|bool
     */
    public function ListarGrupoAlvoAssociadoVeiculoDetalhe(\StructType\ListarGrupoAlvoAssociadoVeiculoDetalhe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoAlvoAssociadoVeiculoDetalhe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarGrupoCercaAssociadoVeiculoDetalhe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoCercaAssociadoVeiculoDetalhe $parameters
     * @return \StructType\ListarGrupoCercaAssociadoVeiculoDetalheResponse|bool
     */
    public function ListarGrupoCercaAssociadoVeiculoDetalhe(\StructType\ListarGrupoCercaAssociadoVeiculoDetalhe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoCercaAssociadoVeiculoDetalhe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarGrupoRotaAssociadoVeiculoDetalhe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoRotaAssociadoVeiculoDetalhe $parameters
     * @return \StructType\ListarGrupoRotaAssociadoVeiculoDetalheResponse|bool
     */
    public function ListarGrupoRotaAssociadoVeiculoDetalhe(\StructType\ListarGrupoRotaAssociadoVeiculoDetalhe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoRotaAssociadoVeiculoDetalhe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarGrupoAlvoEnviadoVeiculoDetalhe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoAlvoEnviadoVeiculoDetalhe $parameters
     * @return \StructType\ListarGrupoAlvoEnviadoVeiculoDetalheResponse|bool
     */
    public function ListarGrupoAlvoEnviadoVeiculoDetalhe(\StructType\ListarGrupoAlvoEnviadoVeiculoDetalhe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoAlvoEnviadoVeiculoDetalhe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarTransmissoesAlvosEnviadoVeiculoDetalhe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTransmissoesAlvosEnviadoVeiculoDetalhe $parameters
     * @return \StructType\ListarTransmissoesAlvosEnviadoVeiculoDetalheResponse|bool
     */
    public function ListarTransmissoesAlvosEnviadoVeiculoDetalhe(\StructType\ListarTransmissoesAlvosEnviadoVeiculoDetalhe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTransmissoesAlvosEnviadoVeiculoDetalhe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarGrupoCercaEnviadoVeiculoDetalhe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoCercaEnviadoVeiculoDetalhe $parameters
     * @return \StructType\ListarGrupoCercaEnviadoVeiculoDetalheResponse|bool
     */
    public function ListarGrupoCercaEnviadoVeiculoDetalhe(\StructType\ListarGrupoCercaEnviadoVeiculoDetalhe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoCercaEnviadoVeiculoDetalhe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarGrupoRotaEnviadoVeiculoDetalhe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoRotaEnviadoVeiculoDetalhe $parameters
     * @return \StructType\ListarGrupoRotaEnviadoVeiculoDetalheResponse|bool
     */
    public function ListarGrupoRotaEnviadoVeiculoDetalhe(\StructType\ListarGrupoRotaEnviadoVeiculoDetalhe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoRotaEnviadoVeiculoDetalhe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarMensagemFormatadaCamposValidacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarMensagemFormatadaCamposValidacao $parameters
     * @return \StructType\ListarMensagemFormatadaCamposValidacaoResponse|bool
     */
    public function ListarMensagemFormatadaCamposValidacao(\StructType\ListarMensagemFormatadaCamposValidacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarMensagemFormatadaCamposValidacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarVeiculo $parameters
     * @return \StructType\ListarVeiculoResponse|bool
     */
    public function ListarVeiculo(\StructType\ListarVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarVeiculoTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarVeiculoTerminal $parameters
     * @return \StructType\ListarVeiculoTerminalResponse|bool
     */
    public function ListarVeiculoTerminal(\StructType\ListarVeiculoTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarVeiculoTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarVeiculoTodos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarVeiculoTodos $parameters
     * @return \StructType\ListarVeiculoTodosResponse|bool
     */
    public function ListarVeiculoTodos(\StructType\ListarVeiculoTodos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarVeiculoTodos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarInconsistenciasTabelaTransicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarInconsistenciasTabelaTransicao $parameters
     * @return \StructType\ListarInconsistenciasTabelaTransicaoResponse|bool
     */
    public function ListarInconsistenciasTabelaTransicao(\StructType\ListarInconsistenciasTabelaTransicao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarInconsistenciasTabelaTransicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarVeiculoSensor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarVeiculoSensor $parameters
     * @return \StructType\ListarVeiculoSensorResponse|bool
     */
    public function ListarVeiculoSensor(\StructType\ListarVeiculoSensor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarVeiculoSensor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarConfiguracaoAlertaComunicacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarConfiguracaoAlertaComunicacao $parameters
     * @return \StructType\ListarConfiguracaoAlertaComunicacaoResponse|bool
     */
    public function ListarConfiguracaoAlertaComunicacao(\StructType\ListarConfiguracaoAlertaComunicacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarConfiguracaoAlertaComunicacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarVeiculosTesteComunicacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarVeiculosTesteComunicacao $parameters
     * @return \StructType\ListarVeiculosTesteComunicacaoResponse|bool
     */
    public function ListarVeiculosTesteComunicacao(\StructType\ListarVeiculosTesteComunicacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarVeiculosTesteComunicacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarTesteComunicacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTesteComunicacao $parameters
     * @return \StructType\ListarTesteComunicacaoResponse|bool
     */
    public function ListarTesteComunicacao(\StructType\ListarTesteComunicacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTesteComunicacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarRelatorioEstatisticas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarRelatorioEstatisticas $parameters
     * @return \StructType\ListarRelatorioEstatisticasResponse|bool
     */
    public function ListarRelatorioEstatisticas(\StructType\ListarRelatorioEstatisticas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarRelatorioEstatisticas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarIntervaloPosicaoAutomaticaAtual
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarIntervaloPosicaoAutomaticaAtual $parameters
     * @return \StructType\ListarIntervaloPosicaoAutomaticaAtualResponse|bool
     */
    public function ListarIntervaloPosicaoAutomaticaAtual(\StructType\ListarIntervaloPosicaoAutomaticaAtual $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarIntervaloPosicaoAutomaticaAtual($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarPontosReferencias
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarPontosReferencias $parameters
     * @return \StructType\ListarPontosReferenciasResponse|bool
     */
    public function ListarPontosReferencias(\StructType\ListarPontosReferencias $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarPontosReferencias($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarTrocaSinalProprietaria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTrocaSinalProprietaria $parameters
     * @return \StructType\ListarTrocaSinalProprietariaResponse|bool
     */
    public function ListarTrocaSinalProprietaria(\StructType\ListarTrocaSinalProprietaria $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTrocaSinalProprietaria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarRelatorioEventosEspeciais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarRelatorioEventosEspeciais $parameters
     * @return \StructType\ListarRelatorioEventosEspeciaisResponse|bool
     */
    public function ListarRelatorioEventosEspeciais(\StructType\ListarRelatorioEventosEspeciais $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarRelatorioEventosEspeciais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarRelatorioEventosOutros
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarRelatorioEventosOutros $parameters
     * @return \StructType\ListarRelatorioEventosOutrosResponse|bool
     */
    public function ListarRelatorioEventosOutros(\StructType\ListarRelatorioEventosOutros $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarRelatorioEventosOutros($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarHistoricoTransmissao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarHistoricoTransmissao $parameters
     * @return \StructType\ListarHistoricoTransmissaoResponse|bool
     */
    public function ListarHistoricoTransmissao(\StructType\ListarHistoricoTransmissao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarHistoricoTransmissao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarGrupoFuncaoProgramavel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoFuncaoProgramavel $parameters
     * @return \StructType\ListarGrupoFuncaoProgramavelResponse|bool
     */
    public function ListarGrupoFuncaoProgramavel(\StructType\ListarGrupoFuncaoProgramavel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoFuncaoProgramavel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarGrupoComFuncProg
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarGrupoComFuncProg $parameters
     * @return \StructType\ListarGrupoComFuncProgResponse|bool
     */
    public function ListarGrupoComFuncProg(\StructType\ListarGrupoComFuncProg $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarGrupoComFuncProg($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarTextoTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTextoTerminal $parameters
     * @return \StructType\ListarTextoTerminalResponse|bool
     */
    public function ListarTextoTerminal(\StructType\ListarTextoTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTextoTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarTextoTerminalByID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTextoTerminalByID $parameters
     * @return \StructType\ListarTextoTerminalByIDResponse|bool
     */
    public function ListarTextoTerminalByID(\StructType\ListarTextoTerminalByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTextoTerminalByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarRegra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarRegra $parameters
     * @return \StructType\ListarRegraResponse|bool
     */
    public function ListarRegra(\StructType\ListarRegra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarRegra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarFuncaoProgramada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarFuncaoProgramada $parameters
     * @return \StructType\ListarFuncaoProgramadaResponse|bool
     */
    public function ListarFuncaoProgramada(\StructType\ListarFuncaoProgramada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarFuncaoProgramada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarVariaveisPersonalizadasPorTipo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarVariaveisPersonalizadasPorTipo $parameters
     * @return \StructType\ListarVariaveisPersonalizadasPorTipoResponse|bool
     */
    public function ListarVariaveisPersonalizadasPorTipo(\StructType\ListarVariaveisPersonalizadasPorTipo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarVariaveisPersonalizadasPorTipo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarVariaveis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarVariaveis $parameters
     * @return \StructType\ListarVariaveisResponse|bool
     */
    public function ListarVariaveis(\StructType\ListarVariaveis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarVariaveis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarReacaoAutoAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarReacaoAutoAll $parameters
     * @return \StructType\ListarReacaoAutoAllResponse|bool
     */
    public function ListarReacaoAutoAll(\StructType\ListarReacaoAutoAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarReacaoAutoAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarComplementosTelevento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarComplementosTelevento $parameters
     * @return \StructType\ListarComplementosTeleventoResponse|bool
     */
    public function ListarComplementosTelevento(\StructType\ListarComplementosTelevento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarComplementosTelevento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarOcorrencias
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarOcorrencias $parameters
     * @return \StructType\ListarOcorrenciasResponse|bool
     */
    public function ListarOcorrencias(\StructType\ListarOcorrencias $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarOcorrencias($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarSiglaEstados
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarSiglaEstados $parameters
     * @return \StructType\ListarSiglaEstadosResponse|bool
     */
    public function ListarSiglaEstados(\StructType\ListarSiglaEstados $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarSiglaEstados($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCidadesDoEstado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCidadesDoEstado $parameters
     * @return \StructType\ListarCidadesDoEstadoResponse|bool
     */
    public function ListarCidadesDoEstado(\StructType\ListarCidadesDoEstado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCidadesDoEstado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarClassesDeReferencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarClassesDeReferencia $parameters
     * @return \StructType\ListarClassesDeReferenciaResponse|bool
     */
    public function ListarClassesDeReferencia(\StructType\ListarClassesDeReferencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarClassesDeReferencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarPontosDeReferenciaParaExibicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarPontosDeReferenciaParaExibicao $parameters
     * @return \StructType\ListarPontosDeReferenciaParaExibicaoResponse|bool
     */
    public function ListarPontosDeReferenciaParaExibicao(\StructType\ListarPontosDeReferenciaParaExibicao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarPontosDeReferenciaParaExibicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarVeiculosProximos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarVeiculosProximos $parameters
     * @return \StructType\ListarVeiculosProximosResponse|bool
     */
    public function ListarVeiculosProximos(\StructType\ListarVeiculosProximos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarVeiculosProximos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarEventosDisponiveisToAlerta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarEventosDisponiveisToAlerta $parameters
     * @return \StructType\ListarEventosDisponiveisToAlertaResponse|bool
     */
    public function ListarEventosDisponiveisToAlerta(\StructType\ListarEventosDisponiveisToAlerta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarEventosDisponiveisToAlerta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarParametrosEnviados
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarParametrosEnviados $parameters
     * @return \StructType\ListarParametrosEnviadosResponse|bool
     */
    public function ListarParametrosEnviados(\StructType\ListarParametrosEnviados $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarParametrosEnviados($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarOperacoesAssociadas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarOperacoesAssociadas $parameters
     * @return \StructType\ListarOperacoesAssociadasResponse|bool
     */
    public function ListarOperacoesAssociadas(\StructType\ListarOperacoesAssociadas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarOperacoesAssociadas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarItensOperacoesAssociadas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarItensOperacoesAssociadas $parameters
     * @return \StructType\ListarItensOperacoesAssociadasResponse|bool
     */
    public function ListarItensOperacoesAssociadas(\StructType\ListarItensOperacoesAssociadas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarItensOperacoesAssociadas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarMotivos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarMotivos $parameters
     * @return \StructType\ListarMotivosResponse|bool
     */
    public function ListarMotivos(\StructType\ListarMotivos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarMotivos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarSensoresPorVeiculos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarSensoresPorVeiculos $parameters
     * @return \StructType\ListarSensoresPorVeiculosResponse|bool
     */
    public function ListarSensoresPorVeiculos(\StructType\ListarSensoresPorVeiculos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarSensoresPorVeiculos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarConfiguracoesDeOpcao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarConfiguracoesDeOpcao $parameters
     * @return \StructType\ListarConfiguracoesDeOpcaoResponse|bool
     */
    public function ListarConfiguracoesDeOpcao(\StructType\ListarConfiguracoesDeOpcao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarConfiguracoesDeOpcao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarSensoresDeAlarme
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarSensoresDeAlarme $parameters
     * @return \StructType\ListarSensoresDeAlarmeResponse|bool
     */
    public function ListarSensoresDeAlarme(\StructType\ListarSensoresDeAlarme $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarSensoresDeAlarme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgExcecaoByIdClientePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgExcecaoByIdClientePerfil $parameters
     * @return \StructType\ListarCfgExcecaoByIdClientePerfilResponse|bool
     */
    public function ListarCfgExcecaoByIdClientePerfil(\StructType\ListarCfgExcecaoByIdClientePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgExcecaoByIdClientePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarCfgTransmissaoByIdClientePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgTransmissaoByIdClientePerfil $parameters
     * @return \StructType\ListarCfgTransmissaoByIdClientePerfilResponse|bool
     */
    public function ListarCfgTransmissaoByIdClientePerfil(\StructType\ListarCfgTransmissaoByIdClientePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgTransmissaoByIdClientePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarCfgInterativoByIdClientePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgInterativoByIdClientePerfil $parameters
     * @return \StructType\ListarCfgInterativoByIdClientePerfilResponse|bool
     */
    public function ListarCfgInterativoByIdClientePerfil(\StructType\ListarCfgInterativoByIdClientePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgInterativoByIdClientePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarCfgAtuadoresByIdClientePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgAtuadoresByIdClientePerfil $parameters
     * @return \StructType\ListarCfgAtuadoresByIdClientePerfilResponse|bool
     */
    public function ListarCfgAtuadoresByIdClientePerfil(\StructType\ListarCfgAtuadoresByIdClientePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgAtuadoresByIdClientePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgOpcoesSeByIdClientePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgOpcoesSeByIdClientePerfil $parameters
     * @return \StructType\ListarCfgOpcoesSeByIdClientePerfilResponse|bool
     */
    public function ListarCfgOpcoesSeByIdClientePerfil(\StructType\ListarCfgOpcoesSeByIdClientePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgOpcoesSeByIdClientePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgSenhasByIdClientePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgSenhasByIdClientePerfil $parameters
     * @return \StructType\ListarCfgSenhasByIdClientePerfilResponse|bool
     */
    public function ListarCfgSenhasByIdClientePerfil(\StructType\ListarCfgSenhasByIdClientePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgSenhasByIdClientePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgLogByIdClientePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgLogByIdClientePerfil $parameters
     * @return \StructType\ListarCfgLogByIdClientePerfilResponse|bool
     */
    public function ListarCfgLogByIdClientePerfil(\StructType\ListarCfgLogByIdClientePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgLogByIdClientePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarCfgTemperaturaByIdClientePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgTemperaturaByIdClientePerfil $parameters
     * @return \StructType\ListarCfgTemperaturaByIdClientePerfilResponse|bool
     */
    public function ListarCfgTemperaturaByIdClientePerfil(\StructType\ListarCfgTemperaturaByIdClientePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgTemperaturaByIdClientePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarMotoristaByIdCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarMotoristaByIdCliente $parameters
     * @return \StructType\ListarMotoristaByIdClienteResponse|bool
     */
    public function ListarMotoristaByIdCliente(\StructType\ListarMotoristaByIdCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarMotoristaByIdCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCfgUmidadeByIdClientePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgUmidadeByIdClientePerfil $parameters
     * @return \StructType\ListarCfgUmidadeByIdClientePerfilResponse|bool
     */
    public function ListarCfgUmidadeByIdClientePerfil(\StructType\ListarCfgUmidadeByIdClientePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgUmidadeByIdClientePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarTodosMensagemPredefinidaByDestino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTodosMensagemPredefinidaByDestino $parameters
     * @return \StructType\ListarTodosMensagemPredefinidaByDestinoResponse|bool
     */
    public function ListarTodosMensagemPredefinidaByDestino(\StructType\ListarTodosMensagemPredefinidaByDestino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTodosMensagemPredefinidaByDestino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarCfgIntervaloComunicacaoAutomatica
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgIntervaloComunicacaoAutomatica $parameters
     * @return \StructType\ListarCfgIntervaloComunicacaoAutomaticaResponse|bool
     */
    public function ListarCfgIntervaloComunicacaoAutomatica(\StructType\ListarCfgIntervaloComunicacaoAutomatica $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgIntervaloComunicacaoAutomatica($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarEspelhamentosByClienteStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarEspelhamentosByClienteStatus $parameters
     * @return \StructType\ListarEspelhamentosByClienteStatusResponse|bool
     */
    public function ListarEspelhamentosByClienteStatus(\StructType\ListarEspelhamentosByClienteStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarEspelhamentosByClienteStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarPontosDaRota
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarPontosDaRota $parameters
     * @return \StructType\ListarPontosDaRotaResponse|bool
     */
    public function ListarPontosDaRota(\StructType\ListarPontosDaRota $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarPontosDaRota($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarCfgMultiplosSensoresByIdClientePerfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCfgMultiplosSensoresByIdClientePerfil $parameters
     * @return \StructType\ListarCfgMultiplosSensoresByIdClientePerfilResponse|bool
     */
    public function ListarCfgMultiplosSensoresByIdClientePerfil(\StructType\ListarCfgMultiplosSensoresByIdClientePerfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCfgMultiplosSensoresByIdClientePerfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarTransmissoesRotasEnviadoVeiculoDetalhe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTransmissoesRotasEnviadoVeiculoDetalhe $parameters
     * @return \StructType\ListarTransmissoesRotasEnviadoVeiculoDetalheResponse|bool
     */
    public function ListarTransmissoesRotasEnviadoVeiculoDetalhe(\StructType\ListarTransmissoesRotasEnviadoVeiculoDetalhe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTransmissoesRotasEnviadoVeiculoDetalhe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListarTransmissoesCercasEnviadoVeiculoDetalhe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarTransmissoesCercasEnviadoVeiculoDetalhe $parameters
     * @return \StructType\ListarTransmissoesCercasEnviadoVeiculoDetalheResponse|bool
     */
    public function ListarTransmissoesCercasEnviadoVeiculoDetalhe(\StructType\ListarTransmissoesCercasEnviadoVeiculoDetalhe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarTransmissoesCercasEnviadoVeiculoDetalhe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarContratosTecnologia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarContratosTecnologia $parameters
     * @return \StructType\ListarContratosTecnologiaResponse|bool
     */
    public function ListarContratosTecnologia(\StructType\ListarContratosTecnologia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarContratosTecnologia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarStatusTransmissaoOperacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarStatusTransmissaoOperacao $parameters
     * @return \StructType\ListarStatusTransmissaoOperacaoResponse|bool
     */
    public function ListarStatusTransmissaoOperacao(\StructType\ListarStatusTransmissaoOperacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarStatusTransmissaoOperacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarIscasTodos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarIscasTodos $parameters
     * @return \StructType\ListarIscasTodosResponse|bool
     */
    public function ListarIscasTodos(\StructType\ListarIscasTodos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarIscasTodos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListarAlvoAssociadoVeiculoResponse|\StructType\ListarAlvosIndexadosResponse|\StructType\ListarAlvosResponse|\StructType\ListarCercaAssociadoVeiculoResponse|\StructType\ListarCercasIndexadoResponse|\StructType\ListarCercasResponse|\StructType\ListarCfgAtuadoresByIdClientePerfilResponse|\StructType\ListarCfgAtuadoresByIdClienteResponse|\StructType\ListarCfgAtuadoresByIdSequenciaResponse|\StructType\ListarCfgAtuadoresByIdTerminalResponse|\StructType\ListarCfgExcecaoByIdClientePerfilResponse|\StructType\ListarCfgExcecaoByIdClienteResponse|\StructType\ListarCfgExcecaoByIdSequenciaResponse|\StructType\ListarCfgExcecaoByIdTerminalResponse|\StructType\ListarCfgInterativoByIdClientePerfilResponse|\StructType\ListarCfgInterativoByIdClienteResponse|\StructType\ListarCfgInterativoByIdSequenciaResponse|\StructType\ListarCfgInterativoByIdTerminalResponse|\StructType\ListarCfgIntervaloComunicacaoAutomaticaResponse|\StructType\ListarCfgLogByIdClientePerfilResponse|\StructType\ListarCfgLogByIdClienteResponse|\StructType\ListarCfgLogByIdSequenciaResponse|\StructType\ListarCfgLogByIdTerminalResponse|\StructType\ListarCfgMultiplosSensoresByIdClientePerfilResponse|\StructType\ListarCfgMultiplosSensoresByIdClienteResponse|\StructType\ListarCfgMultiplosSensoresByIdSequenciaResponse|\StructType\ListarCfgMultiplosSensoresByIdTerminalResponse|\StructType\ListarCfgOpcoesSeByIdClientePerfilResponse|\StructType\ListarCfgOpcoesSeByIdClienteResponse|\StructType\ListarCfgOpcoesSeByIdSequenciaResponse|\StructType\ListarCfgOpcoesSeByIdTerminalResponse|\StructType\ListarCfgOpcoesSegByIdClientePerfilResponse|\StructType\ListarCfgOpcoesSegByIdClienteResponse|\StructType\ListarCfgOpcoesSegByIdSequenciaResponse|\StructType\ListarCfgOpcoesSegByIdTerminalResponse|\StructType\ListarCfgSenhasByIdClientePerfilResponse|\StructType\ListarCfgSenhasByIdClienteResponse|\StructType\ListarCfgSenhasByIdSequenciaResponse|\StructType\ListarCfgSenhasByIdTerminalResponse|\StructType\ListarCfgTemperaturaByIdClientePerfilResponse|\StructType\ListarCfgTemperaturaByIdClienteResponse|\StructType\ListarCfgTemperaturaByIdSequenciaResponse|\StructType\ListarCfgTemperaturaByIdTerminalResponse|\StructType\ListarCfgTransicaoByIdClienteResponse|\StructType\ListarCfgTransicaoByIdSequenciaResponse|\StructType\ListarCfgTransicaoResponse|\StructType\ListarCfgTransmissaoByIdClientePerfilResponse|\StructType\ListarCfgTransmissaoByIdClienteResponse|\StructType\ListarCfgTransmissaoByIdSequenciaResponse|\StructType\ListarCfgTransmissaoByIdTerminalResponse|\StructType\ListarCfgUmidadeByIdClientePerfilResponse|\StructType\ListarCfgUmidadeByIdClienteResponse|\StructType\ListarCfgUmidadeByIdSequenciaResponse|\StructType\ListarCfgUmidadeByIdTerminalResponse|\StructType\ListarCidadesDoEstadoResponse|\StructType\ListarClassesDeReferenciaResponse|\StructType\ListarComplementosTeleventoResponse|\StructType\ListarConfiguracaoAlertaComunicacaoResponse|\StructType\ListarConfiguracoesDeOpcaoResponse|\StructType\ListarContratosTecnologiaResponse|\StructType\ListarEspelhamentosByClienteStatusResponse|\StructType\ListarEventosDisponiveisToAlertaResponse|\StructType\ListarFuncaoProgramadaResponse|\StructType\ListarFuncoesProgramadasResponse|\StructType\ListarGrupoAlvoAssociadoVeiculoDetalheResponse|\StructType\ListarGrupoAlvoEnviadoVeiculoDetalheResponse|\StructType\ListarGrupoAlvoResponse|\StructType\ListarGrupoCercaAssociadoVeiculoDetalheResponse|\StructType\ListarGrupoCercaEnviadoVeiculoDetalheResponse|\StructType\ListarGrupoCercasResponse|\StructType\ListarGrupoComFuncProgResponse|\StructType\ListarGrupoFuncaoProgramavelResponse|\StructType\ListarGrupoMensagemFormatadaDetalheResponse|\StructType\ListarGrupoMensagemFormatadaResponse|\StructType\ListarGrupoRotaAssociadoVeiculoDetalheResponse|\StructType\ListarGrupoRotaEnviadoVeiculoDetalheResponse|\StructType\ListarGrupoRotasResponse|\StructType\ListarHistoricoTransmissaoResponse|\StructType\ListarInconsistenciasTabelaTransicaoResponse|\StructType\ListarIntervaloPosicaoAutomaticaAtualResponse|\StructType\ListarIscasTodosResponse|\StructType\ListarItensCfgModTransicaoResponse|\StructType\ListarItensOperacaoByOperacaoResponse|\StructType\ListarItensOperacoesAssociadasResponse|\StructType\ListarMensagemFormatadaAssociadaDestinoResponse|\StructType\ListarMensagemFormatadaAssociadaOrigemResponse|\StructType\ListarMensagemFormatadaCamposValidacaoResponse|\StructType\ListarMensagemFormatadaEnviadaResponse|\StructType\ListarMensagemFormatadaResponse|\StructType\ListarMensagemPredefinidaResponse|\StructType\ListarModTransicaoResponse|\StructType\ListarMotivosResponse|\StructType\ListarMotoristaByIdClienteResponse|\StructType\ListarOcorrenciasResponse|\StructType\ListarOperacaoByClienteResponse|\StructType\ListarOperacoesAssociadasResponse|\StructType\ListarParametrosEnviadosResponse|\StructType\ListarParametrosVeiculoSecaoResponse|\StructType\ListarParametroVeiculoResponse|\StructType\ListarPerfilConfiguracaoByIdClienteResponse|\StructType\ListarPerfilParametroVeiculoResponse|\StructType\ListarPontosDaRotaResponse|\StructType\ListarPontosDeReferenciaParaExibicaoResponse|\StructType\ListarPontosReferenciasResponse|\StructType\ListarReacaoAutoAllResponse|\StructType\ListarRegraResponse|\StructType\ListarRelatorioEstatisticasResponse|\StructType\ListarRelatorioEventosEspeciaisResponse|\StructType\ListarRelatorioEventosOutrosResponse|\StructType\ListarRotaAssociadoVeiculoResponse|\StructType\ListarRotasIndexadoResponse|\StructType\ListarRotasResponse|\StructType\ListarSensoresDeAlarmeResponse|\StructType\ListarSensoresPorVeiculosResponse|\StructType\ListarSiglaEstadosResponse|\StructType\ListarStatusTransmissaoOperacaoResponse|\StructType\ListarTesteComunicacaoResponse|\StructType\ListarTextoTerminalByIDResponse|\StructType\ListarTextoTerminalResponse|\StructType\ListarTodosGrupoMensagemFormatadaResponse|\StructType\ListarTodosMensagemFormatadaResponse|\StructType\ListarTodosMensagemPredefinidaAssociadaResponse|\StructType\ListarTodosMensagemPredefinidaByDestinoResponse|\StructType\ListarTodosMensagemPredefinidaResponse|\StructType\ListarTodosModTransicaoResponse|\StructType\ListarTransmissoesAlvosEnviadoVeiculoDetalheResponse|\StructType\ListarTransmissoesCercasEnviadoVeiculoDetalheResponse|\StructType\ListarTransmissoesRotasEnviadoVeiculoDetalheResponse|\StructType\ListarTrocaSinalProprietariaResponse|\StructType\ListarVariaveisPersonalizadasPorTipoResponse|\StructType\ListarVariaveisResponse|\StructType\ListarVeiculoResponse|\StructType\ListarVeiculoSensorResponse|\StructType\ListarVeiculosProximosResponse|\StructType\ListarVeiculosTesteComunicacaoResponse|\StructType\ListarVeiculoTerminalResponse|\StructType\ListarVeiculoTodosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
