<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lista ServiceType
 * @subpackage Services
 */
class Lista extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListaPerfis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPerfis $parameters
     * @return \StructType\ListaPerfisResponse|bool
     */
    public function ListaPerfis(\StructType\ListaPerfis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListaPerfis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPerfisCerca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPerfisCerca $parameters
     * @return \StructType\ListaPerfisCercaResponse|bool
     */
    public function ListaPerfisCerca(\StructType\ListaPerfisCerca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListaPerfisCerca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPerfisRota
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPerfisRota $parameters
     * @return \StructType\ListaPerfisRotaResponse|bool
     */
    public function ListaPerfisRota(\StructType\ListaPerfisRota $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListaPerfisRota($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListaPerfisCercaResponse|\StructType\ListaPerfisResponse|\StructType\ListaPerfisRotaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
