<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Importar ServiceType
 * @subpackage Services
 */
class Importar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ImportarAlvo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportarAlvo $parameters
     * @return \StructType\ImportarAlvoResponse|bool
     */
    public function ImportarAlvo(\StructType\ImportarAlvo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportarAlvo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportarCerca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportarCerca $parameters
     * @return \StructType\ImportarCercaResponse|bool
     */
    public function ImportarCerca(\StructType\ImportarCerca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportarCerca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportarRota
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportarRota $parameters
     * @return \StructType\ImportarRotaResponse|bool
     */
    public function ImportarRota(\StructType\ImportarRota $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportarRota($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportarCercaRotograma
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportarCercaRotograma $parameters
     * @return \StructType\ImportarCercaRotogramaResponse|bool
     */
    public function ImportarCercaRotograma(\StructType\ImportarCercaRotograma $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportarCercaRotograma($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportarMensagemFormatada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportarMensagemFormatada $parameters
     * @return \StructType\ImportarMensagemFormatadaResponse|bool
     */
    public function ImportarMensagemFormatada(\StructType\ImportarMensagemFormatada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportarMensagemFormatada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportarPontoDeReferencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportarPontoDeReferencia $parameters
     * @return \StructType\ImportarPontoDeReferenciaResponse|bool
     */
    public function ImportarPontoDeReferencia(\StructType\ImportarPontoDeReferencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportarPontoDeReferencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ImportarAlvoResponse|\StructType\ImportarCercaResponse|\StructType\ImportarCercaRotogramaResponse|\StructType\ImportarMensagemFormatadaResponse|\StructType\ImportarPontoDeReferenciaResponse|\StructType\ImportarRotaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
