<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Desassociar ServiceType
 * @subpackage Services
 */
class Desassociar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * DesassociarMensagemFormatadaVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesassociarMensagemFormatadaVeiculo $parameters
     * @return \StructType\DesassociarMensagemFormatadaVeiculoResponse|bool
     */
    public function DesassociarMensagemFormatadaVeiculo(\StructType\DesassociarMensagemFormatadaVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesassociarMensagemFormatadaVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DesassociarMensagemFormatadaVeiculoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesassociarMensagemFormatadaVeiculoXML $parameters
     * @return \StructType\DesassociarMensagemFormatadaVeiculoXMLResponse|bool
     */
    public function DesassociarMensagemFormatadaVeiculoXML(\StructType\DesassociarMensagemFormatadaVeiculoXML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesassociarMensagemFormatadaVeiculoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesassociarCercasDeVeiculos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesassociarCercasDeVeiculos $parameters
     * @return \StructType\DesassociarCercasDeVeiculosResponse|bool
     */
    public function DesassociarCercasDeVeiculos(\StructType\DesassociarCercasDeVeiculos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesassociarCercasDeVeiculos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesassociarAlvosDeVeiculos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesassociarAlvosDeVeiculos $parameters
     * @return \StructType\DesassociarAlvosDeVeiculosResponse|bool
     */
    public function DesassociarAlvosDeVeiculos(\StructType\DesassociarAlvosDeVeiculos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesassociarAlvosDeVeiculos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesassociarRotasDeVeiculos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesassociarRotasDeVeiculos $parameters
     * @return \StructType\DesassociarRotasDeVeiculosResponse|bool
     */
    public function DesassociarRotasDeVeiculos(\StructType\DesassociarRotasDeVeiculos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesassociarRotasDeVeiculos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DesassociarAlvosDeVeiculosResponse|\StructType\DesassociarCercasDeVeiculosResponse|\StructType\DesassociarMensagemFormatadaVeiculoResponse|\StructType\DesassociarMensagemFormatadaVeiculoXMLResponse|\StructType\DesassociarRotasDeVeiculosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
