<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListarVeiculoTerminal StructType
 * Meta information extracted from the WSDL
 * - type: tns:ListarVeiculoTerminal
 * @subpackage Structs
 */
class ListarVeiculoTerminal extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The Terminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Terminal;
    /**
     * Constructor method for ListarVeiculoTerminal
     * @uses ListarVeiculoTerminal::setUsuario()
     * @uses ListarVeiculoTerminal::setSenha()
     * @uses ListarVeiculoTerminal::setTerminal()
     * @param string $usuario
     * @param string $senha
     * @param int $terminal
     */
    public function __construct($usuario = null, $senha = null, $terminal = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setTerminal($terminal);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ListarVeiculoTerminal
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ListarVeiculoTerminal
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get Terminal value
     * @return int|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param int $terminal
     * @return \StructType\ListarVeiculoTerminal
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: int
        if (!is_null($terminal) && !(is_int($terminal) || ctype_digit($terminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminal, true), gettype($terminal)), __LINE__);
        }
        $this->Terminal = $terminal;
        return $this;
    }
}
