<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirVeiculoSensor StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirVeiculoSensor
 * @subpackage Structs
 */
class ExcluirVeiculoSensor extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdCadSensor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCadSensor;
    /**
     * Constructor method for ExcluirVeiculoSensor
     * @uses ExcluirVeiculoSensor::setUsuario()
     * @uses ExcluirVeiculoSensor::setSenha()
     * @uses ExcluirVeiculoSensor::setIdCadSensor()
     * @param string $usuario
     * @param string $senha
     * @param int $idCadSensor
     */
    public function __construct($usuario = null, $senha = null, $idCadSensor = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdCadSensor($idCadSensor);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirVeiculoSensor
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirVeiculoSensor
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdCadSensor value
     * @return int|null
     */
    public function getIdCadSensor()
    {
        return $this->IdCadSensor;
    }
    /**
     * Set IdCadSensor value
     * @param int $idCadSensor
     * @return \StructType\ExcluirVeiculoSensor
     */
    public function setIdCadSensor($idCadSensor = null)
    {
        // validation for constraint: int
        if (!is_null($idCadSensor) && !(is_int($idCadSensor) || ctype_digit($idCadSensor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCadSensor, true), gettype($idCadSensor)), __LINE__);
        }
        $this->IdCadSensor = $idCadSensor;
        return $this;
    }
}
