<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComandoIscaConfigTempos StructType
 * Meta information extracted from the WSDL
 * - type: tns:ComandoIscaConfigTempos
 * @subpackage Structs
 */
class ComandoIscaConfigTempos extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdIsca
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IdIsca;
    /**
     * The IntervaloEnvioGPRS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IntervaloEnvioGPRS;
    /**
     * The IntervaloEnvioGPRSemModoEmergencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IntervaloEnvioGPRSemModoEmergencia;
    /**
     * Constructor method for ComandoIscaConfigTempos
     * @uses ComandoIscaConfigTempos::setUsuario()
     * @uses ComandoIscaConfigTempos::setSenha()
     * @uses ComandoIscaConfigTempos::setIdIsca()
     * @uses ComandoIscaConfigTempos::setIntervaloEnvioGPRS()
     * @uses ComandoIscaConfigTempos::setIntervaloEnvioGPRSemModoEmergencia()
     * @param string $usuario
     * @param string $senha
     * @param string $idIsca
     * @param int $intervaloEnvioGPRS
     * @param int $intervaloEnvioGPRSemModoEmergencia
     */
    public function __construct($usuario = null, $senha = null, $idIsca = null, $intervaloEnvioGPRS = null, $intervaloEnvioGPRSemModoEmergencia = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdIsca($idIsca)
            ->setIntervaloEnvioGPRS($intervaloEnvioGPRS)
            ->setIntervaloEnvioGPRSemModoEmergencia($intervaloEnvioGPRSemModoEmergencia);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ComandoIscaConfigTempos
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ComandoIscaConfigTempos
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdIsca value
     * @return string|null
     */
    public function getIdIsca()
    {
        return $this->IdIsca;
    }
    /**
     * Set IdIsca value
     * @param string $idIsca
     * @return \StructType\ComandoIscaConfigTempos
     */
    public function setIdIsca($idIsca = null)
    {
        // validation for constraint: string
        if (!is_null($idIsca) && !is_string($idIsca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idIsca, true), gettype($idIsca)), __LINE__);
        }
        $this->IdIsca = $idIsca;
        return $this;
    }
    /**
     * Get IntervaloEnvioGPRS value
     * @return int|null
     */
    public function getIntervaloEnvioGPRS()
    {
        return $this->IntervaloEnvioGPRS;
    }
    /**
     * Set IntervaloEnvioGPRS value
     * @param int $intervaloEnvioGPRS
     * @return \StructType\ComandoIscaConfigTempos
     */
    public function setIntervaloEnvioGPRS($intervaloEnvioGPRS = null)
    {
        // validation for constraint: int
        if (!is_null($intervaloEnvioGPRS) && !(is_int($intervaloEnvioGPRS) || ctype_digit($intervaloEnvioGPRS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intervaloEnvioGPRS, true), gettype($intervaloEnvioGPRS)), __LINE__);
        }
        $this->IntervaloEnvioGPRS = $intervaloEnvioGPRS;
        return $this;
    }
    /**
     * Get IntervaloEnvioGPRSemModoEmergencia value
     * @return int|null
     */
    public function getIntervaloEnvioGPRSemModoEmergencia()
    {
        return $this->IntervaloEnvioGPRSemModoEmergencia;
    }
    /**
     * Set IntervaloEnvioGPRSemModoEmergencia value
     * @param int $intervaloEnvioGPRSemModoEmergencia
     * @return \StructType\ComandoIscaConfigTempos
     */
    public function setIntervaloEnvioGPRSemModoEmergencia($intervaloEnvioGPRSemModoEmergencia = null)
    {
        // validation for constraint: int
        if (!is_null($intervaloEnvioGPRSemModoEmergencia) && !(is_int($intervaloEnvioGPRSemModoEmergencia) || ctype_digit($intervaloEnvioGPRSemModoEmergencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intervaloEnvioGPRSemModoEmergencia, true), gettype($intervaloEnvioGPRSemModoEmergencia)), __LINE__);
        }
        $this->IntervaloEnvioGPRSemModoEmergencia = $intervaloEnvioGPRSemModoEmergencia;
        return $this;
    }
}
