<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Autorizar StructType
 * Meta information extracted from the WSDL
 * - type: tns:Autorizar
 * @subpackage Structs
 */
class Autorizar extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $idVeiculo;
    /**
     * The TipoAutorizacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoAutorizacao;
    /**
     * Constructor method for Autorizar
     * @uses Autorizar::setUsuario()
     * @uses Autorizar::setSenha()
     * @uses Autorizar::setIdVeiculo()
     * @uses Autorizar::setTipoAutorizacao()
     * @param string $usuario
     * @param string $senha
     * @param string $idVeiculo
     * @param string $tipoAutorizacao
     */
    public function __construct($usuario = null, $senha = null, $idVeiculo = null, $tipoAutorizacao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdVeiculo($idVeiculo)
            ->setTipoAutorizacao($tipoAutorizacao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\Autorizar
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\Autorizar
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idVeiculo value
     * @return string|null
     */
    public function getIdVeiculo()
    {
        return $this->idVeiculo;
    }
    /**
     * Set idVeiculo value
     * @param string $idVeiculo
     * @return \StructType\Autorizar
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: string
        if (!is_null($idVeiculo) && !is_string($idVeiculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->idVeiculo = $idVeiculo;
        return $this;
    }
    /**
     * Get TipoAutorizacao value
     * @return string|null
     */
    public function getTipoAutorizacao()
    {
        return $this->TipoAutorizacao;
    }
    /**
     * Set TipoAutorizacao value
     * @param string $tipoAutorizacao
     * @return \StructType\Autorizar
     */
    public function setTipoAutorizacao($tipoAutorizacao = null)
    {
        // validation for constraint: string
        if (!is_null($tipoAutorizacao) && !is_string($tipoAutorizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoAutorizacao, true), gettype($tipoAutorizacao)), __LINE__);
        }
        $this->TipoAutorizacao = $tipoAutorizacao;
        return $this;
    }
}
