<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AtualizarConfiguracoesSenhas StructType
 * Meta information extracted from the WSDL
 * - type: tns:AtualizarConfiguracoesSenhas
 * @subpackage Structs
 */
class AtualizarConfiguracoesSenhas extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdTerminal
     * @var int
     */
    public $IdTerminal;
    /**
     * The IDSequencia
     * @var int
     */
    public $IDSequencia;
    /**
     * The SenhaMotorista
     * @var int
     */
    public $SenhaMotorista;
    /**
     * The SenhaSuper
     * @var int
     */
    public $SenhaSuper;
    /**
     * The SenhaManobrista
     * @var int
     */
    public $SenhaManobrista;
    /**
     * The SenhaPanico
     * @var int
     */
    public $SenhaPanico;
    /**
     * The id_config
     * @var int
     */
    public $id_config;
    /**
     * Constructor method for AtualizarConfiguracoesSenhas
     * @uses AtualizarConfiguracoesSenhas::setUsuario()
     * @uses AtualizarConfiguracoesSenhas::setSenha()
     * @uses AtualizarConfiguracoesSenhas::setIdTerminal()
     * @uses AtualizarConfiguracoesSenhas::setIDSequencia()
     * @uses AtualizarConfiguracoesSenhas::setSenhaMotorista()
     * @uses AtualizarConfiguracoesSenhas::setSenhaSuper()
     * @uses AtualizarConfiguracoesSenhas::setSenhaManobrista()
     * @uses AtualizarConfiguracoesSenhas::setSenhaPanico()
     * @uses AtualizarConfiguracoesSenhas::setId_config()
     * @param string $usuario
     * @param string $senha
     * @param int $idTerminal
     * @param int $iDSequencia
     * @param int $senhaMotorista
     * @param int $senhaSuper
     * @param int $senhaManobrista
     * @param int $senhaPanico
     * @param int $id_config
     */
    public function __construct($usuario = null, $senha = null, $idTerminal = null, $iDSequencia = null, $senhaMotorista = null, $senhaSuper = null, $senhaManobrista = null, $senhaPanico = null, $id_config = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdTerminal($idTerminal)
            ->setIDSequencia($iDSequencia)
            ->setSenhaMotorista($senhaMotorista)
            ->setSenhaSuper($senhaSuper)
            ->setSenhaManobrista($senhaManobrista)
            ->setSenhaPanico($senhaPanico)
            ->setId_config($id_config);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\AtualizarConfiguracoesSenhas
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\AtualizarConfiguracoesSenhas
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdTerminal value
     * @return int|null
     */
    public function getIdTerminal()
    {
        return $this->IdTerminal;
    }
    /**
     * Set IdTerminal value
     * @param int $idTerminal
     * @return \StructType\AtualizarConfiguracoesSenhas
     */
    public function setIdTerminal($idTerminal = null)
    {
        // validation for constraint: int
        if (!is_null($idTerminal) && !(is_int($idTerminal) || ctype_digit($idTerminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTerminal, true), gettype($idTerminal)), __LINE__);
        }
        $this->IdTerminal = $idTerminal;
        return $this;
    }
    /**
     * Get IDSequencia value
     * @return int|null
     */
    public function getIDSequencia()
    {
        return $this->IDSequencia;
    }
    /**
     * Set IDSequencia value
     * @param int $iDSequencia
     * @return \StructType\AtualizarConfiguracoesSenhas
     */
    public function setIDSequencia($iDSequencia = null)
    {
        // validation for constraint: int
        if (!is_null($iDSequencia) && !(is_int($iDSequencia) || ctype_digit($iDSequencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDSequencia, true), gettype($iDSequencia)), __LINE__);
        }
        $this->IDSequencia = $iDSequencia;
        return $this;
    }
    /**
     * Get SenhaMotorista value
     * @return int|null
     */
    public function getSenhaMotorista()
    {
        return $this->SenhaMotorista;
    }
    /**
     * Set SenhaMotorista value
     * @param int $senhaMotorista
     * @return \StructType\AtualizarConfiguracoesSenhas
     */
    public function setSenhaMotorista($senhaMotorista = null)
    {
        // validation for constraint: int
        if (!is_null($senhaMotorista) && !(is_int($senhaMotorista) || ctype_digit($senhaMotorista))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($senhaMotorista, true), gettype($senhaMotorista)), __LINE__);
        }
        $this->SenhaMotorista = $senhaMotorista;
        return $this;
    }
    /**
     * Get SenhaSuper value
     * @return int|null
     */
    public function getSenhaSuper()
    {
        return $this->SenhaSuper;
    }
    /**
     * Set SenhaSuper value
     * @param int $senhaSuper
     * @return \StructType\AtualizarConfiguracoesSenhas
     */
    public function setSenhaSuper($senhaSuper = null)
    {
        // validation for constraint: int
        if (!is_null($senhaSuper) && !(is_int($senhaSuper) || ctype_digit($senhaSuper))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($senhaSuper, true), gettype($senhaSuper)), __LINE__);
        }
        $this->SenhaSuper = $senhaSuper;
        return $this;
    }
    /**
     * Get SenhaManobrista value
     * @return int|null
     */
    public function getSenhaManobrista()
    {
        return $this->SenhaManobrista;
    }
    /**
     * Set SenhaManobrista value
     * @param int $senhaManobrista
     * @return \StructType\AtualizarConfiguracoesSenhas
     */
    public function setSenhaManobrista($senhaManobrista = null)
    {
        // validation for constraint: int
        if (!is_null($senhaManobrista) && !(is_int($senhaManobrista) || ctype_digit($senhaManobrista))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($senhaManobrista, true), gettype($senhaManobrista)), __LINE__);
        }
        $this->SenhaManobrista = $senhaManobrista;
        return $this;
    }
    /**
     * Get SenhaPanico value
     * @return int|null
     */
    public function getSenhaPanico()
    {
        return $this->SenhaPanico;
    }
    /**
     * Set SenhaPanico value
     * @param int $senhaPanico
     * @return \StructType\AtualizarConfiguracoesSenhas
     */
    public function setSenhaPanico($senhaPanico = null)
    {
        // validation for constraint: int
        if (!is_null($senhaPanico) && !(is_int($senhaPanico) || ctype_digit($senhaPanico))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($senhaPanico, true), gettype($senhaPanico)), __LINE__);
        }
        $this->SenhaPanico = $senhaPanico;
        return $this;
    }
    /**
     * Get id_config value
     * @return int|null
     */
    public function getId_config()
    {
        return $this->id_config;
    }
    /**
     * Set id_config value
     * @param int $id_config
     * @return \StructType\AtualizarConfiguracoesSenhas
     */
    public function setId_config($id_config = null)
    {
        // validation for constraint: int
        if (!is_null($id_config) && !(is_int($id_config) || ctype_digit($id_config))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id_config, true), gettype($id_config)), __LINE__);
        }
        $this->id_config = $id_config;
        return $this;
    }
}
