<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociarMensagemPredefinidaXML StructType
 * Meta information extracted from the WSDL
 * - type: tns:AssociarMensagemPredefinidaXML
 * @subpackage Structs
 */
class AssociarMensagemPredefinidaXML extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdVeiculo
     * @var int
     */
    public $IdVeiculo;
    /**
     * The XML
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $XML;
    /**
     * Constructor method for AssociarMensagemPredefinidaXML
     * @uses AssociarMensagemPredefinidaXML::setUsuario()
     * @uses AssociarMensagemPredefinidaXML::setSenha()
     * @uses AssociarMensagemPredefinidaXML::setIdVeiculo()
     * @uses AssociarMensagemPredefinidaXML::setXML()
     * @param string $usuario
     * @param string $senha
     * @param int $idVeiculo
     * @param string $xML
     */
    public function __construct($usuario = null, $senha = null, $idVeiculo = null, $xML = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdVeiculo($idVeiculo)
            ->setXML($xML);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\AssociarMensagemPredefinidaXML
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\AssociarMensagemPredefinidaXML
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdVeiculo value
     * @return int|null
     */
    public function getIdVeiculo()
    {
        return $this->IdVeiculo;
    }
    /**
     * Set IdVeiculo value
     * @param int $idVeiculo
     * @return \StructType\AssociarMensagemPredefinidaXML
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: int
        if (!is_null($idVeiculo) && !(is_int($idVeiculo) || ctype_digit($idVeiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->IdVeiculo = $idVeiculo;
        return $this;
    }
    /**
     * Get XML value
     * @return string|null
     */
    public function getXML()
    {
        return $this->XML;
    }
    /**
     * Set XML value
     * @param string $xML
     * @return \StructType\AssociarMensagemPredefinidaXML
     */
    public function setXML($xML = null)
    {
        // validation for constraint: string
        if (!is_null($xML) && !is_string($xML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xML, true), gettype($xML)), __LINE__);
        }
        $this->XML = $xML;
        return $this;
    }
}
