<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Operacao ServiceType
 * @subpackage Services
 */
class Operacao extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Operacao_Associar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Operacao_Associar $parameters
     * @return \StructType\Operacao_AssociarResponse|bool
     */
    public function Operacao_Associar(\StructType\Operacao_Associar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Operacao_Associar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Operacao_Transmitir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Operacao_Transmitir $parameters
     * @return \StructType\Operacao_TransmitirResponse|bool
     */
    public function Operacao_Transmitir(\StructType\Operacao_Transmitir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Operacao_Transmitir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Operacao_SolicitaListaPerfilConfiguracao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Operacao_SolicitaListaPerfilConfiguracao $parameters
     * @return \StructType\Operacao_SolicitaListaPerfilConfiguracaoResponse|bool
     */
    public function Operacao_SolicitaListaPerfilConfiguracao(\StructType\Operacao_SolicitaListaPerfilConfiguracao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Operacao_SolicitaListaPerfilConfiguracao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Operacao_Associar_Perfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Operacao_Associar_Perfil $parameters
     * @return \StructType\Operacao_Associar_PerfilResponse|bool
     */
    public function Operacao_Associar_Perfil(\StructType\Operacao_Associar_Perfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Operacao_Associar_Perfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Operacao_Transmitir_Perfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Operacao_Transmitir_Perfil $parameters
     * @return \StructType\Operacao_Transmitir_PerfilResponse|bool
     */
    public function Operacao_Transmitir_Perfil(\StructType\Operacao_Transmitir_Perfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Operacao_Transmitir_Perfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OperacaoSolicitarStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OperacaoSolicitarStatus $parameters
     * @return \StructType\OperacaoSolicitarStatusResponse|bool
     */
    public function OperacaoSolicitarStatus(\StructType\OperacaoSolicitarStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OperacaoSolicitarStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Operacao_SolicitaListaOperacoes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Operacao_SolicitaListaOperacoes $parameters
     * @return \StructType\Operacao_SolicitaListaOperacoesResponse|bool
     */
    public function Operacao_SolicitaListaOperacoes(\StructType\Operacao_SolicitaListaOperacoes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Operacao_SolicitaListaOperacoes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OperacaoSolicitarStatusResponse|\StructType\Operacao_AssociarResponse|\StructType\Operacao_Associar_PerfilResponse|\StructType\Operacao_SolicitaListaOperacoesResponse|\StructType\Operacao_SolicitaListaPerfilConfiguracaoResponse|\StructType\Operacao_TransmitirResponse|\StructType\Operacao_Transmitir_PerfilResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
