<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestContextType StructType
 * @subpackage Structs
 */
class RequestContextType extends AbstractStructBase
{
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * @var string[]
     */
    public $Language;
    /**
     * Constructor method for RequestContextType
     * @uses RequestContextType::setId()
     * @uses RequestContextType::setLanguage()
     * @param string $id
     * @param string[] $language
     */
    public function __construct($id = null, array $language = array())
    {
        $this
            ->setId($id)
            ->setLanguage($language);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\RequestContextType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Language value
     * @return string[]|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestContextTypeLanguageItem) {
            // validation for constraint: enumeration
            if (!\EnumType\Language::valueIsValid($requestContextTypeLanguageItem)) {
                $invalidValues[] = is_object($requestContextTypeLanguageItem) ? get_class($requestContextTypeLanguageItem) : sprintf('%s(%s)', gettype($requestContextTypeLanguageItem), var_export($requestContextTypeLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\Language::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $language
     * @return \StructType\RequestContextType
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: array
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($language) && count($language) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Add item to Language value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RequestContextType
     */
    public function addToLanguage($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->Language) && count($this->Language) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->Language)), __LINE__);
        }
        $this->Language[] = $item;
        return $this;
    }
}
