<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadEstablishmentByEstablishmentNumberRequestType
 * StructType
 * @subpackage Structs
 */
class ReadEstablishmentByEstablishmentNumberRequestType extends AbstractStructBase
{
    /**
     * The EstablishmentNumber
     * Meta information extracted from the WSDL
     * - base: xs:long
     * - pattern: [2-9][0-9]{9}
     * - ref: datamodel:EstablishmentNumber
     * @var int
     */
    public $EstablishmentNumber;
    /**
     * The TypeOfResult
     * @var string
     */
    public $TypeOfResult;
    /**
     * Constructor method for ReadEstablishmentByEstablishmentNumberRequestType
     * @uses ReadEstablishmentByEstablishmentNumberRequestType::setEstablishmentNumber()
     * @uses ReadEstablishmentByEstablishmentNumberRequestType::setTypeOfResult()
     * @param int $establishmentNumber
     * @param string $typeOfResult
     */
    public function __construct($establishmentNumber = null, $typeOfResult = null)
    {
        $this
            ->setEstablishmentNumber($establishmentNumber)
            ->setTypeOfResult($typeOfResult);
    }
    /**
     * Get EstablishmentNumber value
     * @return int|null
     */
    public function getEstablishmentNumber()
    {
        return $this->EstablishmentNumber;
    }
    /**
     * Set EstablishmentNumber value
     * @param int $establishmentNumber
     * @return \StructType\ReadEstablishmentByEstablishmentNumberRequestType
     */
    public function setEstablishmentNumber($establishmentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($establishmentNumber) && !(is_int($establishmentNumber) || ctype_digit($establishmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishmentNumber, true), gettype($establishmentNumber)), __LINE__);
        }
        // validation for constraint: pattern([2-9][0-9]{9})
        if (!is_null($establishmentNumber) && !preg_match('/[2-9][0-9]{9}/', $establishmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [2-9][0-9]{9}', var_export($establishmentNumber, true)), __LINE__);
        }
        $this->EstablishmentNumber = $establishmentNumber;
        return $this;
    }
    /**
     * Get TypeOfResult value
     * @return string|null
     */
    public function getTypeOfResult()
    {
        return $this->TypeOfResult;
    }
    /**
     * Set TypeOfResult value
     * @uses \EnumType\RepresentationType::valueIsValid()
     * @uses \EnumType\RepresentationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfResult
     * @return \StructType\ReadEstablishmentByEstablishmentNumberRequestType
     */
    public function setTypeOfResult($typeOfResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RepresentationType::valueIsValid($typeOfResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RepresentationType', is_array($typeOfResult) ? implode(', ', $typeOfResult) : var_export($typeOfResult, true), implode(', ', \EnumType\RepresentationType::getValidValues())), __LINE__);
        }
        $this->TypeOfResult = $typeOfResult;
        return $this;
    }
}
