<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityClassificationType StructType
 * @subpackage Structs
 */
class ActivityClassificationType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\DescriptionType[]
     */
    public $Description;
    /**
     * Constructor method for ActivityClassificationType
     * @uses ActivityClassificationType::setCode()
     * @uses ActivityClassificationType::setDescription()
     * @param string $code
     * @param \StructType\DescriptionType[] $description
     */
    public function __construct($code = null, array $description = array())
    {
        $this
            ->setCode($code)
            ->setDescription($description);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @uses \EnumType\ActivityClassificationCodeType::valueIsValid()
     * @uses \EnumType\ActivityClassificationCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\ActivityClassificationType
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivityClassificationCodeType::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActivityClassificationCodeType', is_array($code) ? implode(', ', $code) : var_export($code, true), implode(', ', \EnumType\ActivityClassificationCodeType::getValidValues())), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityClassificationTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$activityClassificationTypeDescriptionItem instanceof \StructType\DescriptionType) {
                $invalidValues[] = is_object($activityClassificationTypeDescriptionItem) ? get_class($activityClassificationTypeDescriptionItem) : sprintf('%s(%s)', gettype($activityClassificationTypeDescriptionItem), var_export($activityClassificationTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType[] $description
     * @return \StructType\ActivityClassificationType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType $item
     * @return \StructType\ActivityClassificationType
     */
    public function addToDescription(\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
}
