<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NaturalPersonFounderType StructType
 * @subpackage Structs
 */
class NaturalPersonFounderType extends AbstractStructBase
{
    /**
     * The EnterpriseNumber
     * Meta information extracted from the WSDL
     * - base: xs:long
     * - pattern: [01]?[0-9]{9}
     * @var int
     */
    public $EnterpriseNumber;
    /**
     * Constructor method for NaturalPersonFounderType
     * @uses NaturalPersonFounderType::setEnterpriseNumber()
     * @param int $enterpriseNumber
     */
    public function __construct($enterpriseNumber = null)
    {
        $this
            ->setEnterpriseNumber($enterpriseNumber);
    }
    /**
     * Get EnterpriseNumber value
     * @return int|null
     */
    public function getEnterpriseNumber()
    {
        return $this->EnterpriseNumber;
    }
    /**
     * Set EnterpriseNumber value
     * @param int $enterpriseNumber
     * @return \StructType\NaturalPersonFounderType
     */
    public function setEnterpriseNumber($enterpriseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($enterpriseNumber) && !(is_int($enterpriseNumber) || ctype_digit($enterpriseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enterpriseNumber, true), gettype($enterpriseNumber)), __LINE__);
        }
        // validation for constraint: pattern([01]?[0-9]{9})
        if (!is_null($enterpriseNumber) && !preg_match('/[01]?[0-9]{9}/', $enterpriseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [01]?[0-9]{9}', var_export($enterpriseNumber, true)), __LINE__);
        }
        $this->EnterpriseNumber = $enterpriseNumber;
        return $this;
    }
}
