<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityGroupAdministrationType StructType
 * @subpackage Structs
 */
class ActivityGroupAdministrationType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The ActivityGroup
     * @var string
     */
    public $ActivityGroup;
    /**
     * Constructor method for ActivityGroupAdministrationType
     * @uses ActivityGroupAdministrationType::setDescription()
     * @uses ActivityGroupAdministrationType::setActivityGroup()
     * @param \StructType\DescriptionType[] $description
     * @param string $activityGroup
     */
    public function __construct(array $description = array(), $activityGroup = null)
    {
        $this
            ->setDescription($description)
            ->setActivityGroup($activityGroup);
    }
    /**
     * Get Description value
     * @return \StructType\DescriptionType[]
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityGroupAdministrationTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$activityGroupAdministrationTypeDescriptionItem instanceof \StructType\DescriptionType) {
                $invalidValues[] = is_object($activityGroupAdministrationTypeDescriptionItem) ? get_class($activityGroupAdministrationTypeDescriptionItem) : sprintf('%s(%s)', gettype($activityGroupAdministrationTypeDescriptionItem), var_export($activityGroupAdministrationTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType[] $description
     * @return \StructType\ActivityGroupAdministrationType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType $item
     * @return \StructType\ActivityGroupAdministrationType
     */
    public function addToDescription(\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get ActivityGroup value
     * @return string|null
     */
    public function getActivityGroup()
    {
        return $this->ActivityGroup;
    }
    /**
     * Set ActivityGroup value
     * @param string $activityGroup
     * @return \StructType\ActivityGroupAdministrationType
     */
    public function setActivityGroup($activityGroup = null)
    {
        // validation for constraint: string
        if (!is_null($activityGroup) && !is_string($activityGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityGroup, true), gettype($activityGroup)), __LINE__);
        }
        $this->ActivityGroup = $activityGroup;
        return $this;
    }
}
