<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NumberToDollars StructType
 * @subpackage Structs
 */
class NumberToDollars extends AbstractStructBase
{
    /**
     * The dNum
     * @var float
     */
    public $dNum;
    /**
     * Constructor method for NumberToDollars
     * @uses NumberToDollars::setDNum()
     * @param float $dNum
     */
    public function __construct($dNum = null)
    {
        $this
            ->setDNum($dNum);
    }
    /**
     * Get dNum value
     * @return float|null
     */
    public function getDNum()
    {
        return $this->dNum;
    }
    /**
     * Set dNum value
     * @param float $dNum
     * @return \StructType\NumberToDollars
     */
    public function setDNum($dNum = null)
    {
        // validation for constraint: float
        if (!is_null($dNum) && !(is_float($dNum) || is_numeric($dNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dNum, true), gettype($dNum)), __LINE__);
        }
        $this->dNum = $dNum;
        return $this;
    }
}
