<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Number ServiceType
 * @subpackage Services
 */
class Number extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NumberToWords
     * Meta information extracted from the WSDL
     * - documentation: Returns the word corresponding to the positive number passed as parameter. Limited to quadrillions.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NumberToWords $parameters
     * @return \StructType\NumberToWordsResponse|bool
     */
    public function NumberToWords(\StructType\NumberToWords $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NumberToWords($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NumberToDollars
     * Meta information extracted from the WSDL
     * - documentation: Returns the non-zero dollar amount of the passed number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NumberToDollars $parameters
     * @return \StructType\NumberToDollarsResponse|bool
     */
    public function NumberToDollars(\StructType\NumberToDollars $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NumberToDollars($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NumberToDollarsResponse|\StructType\NumberToWordsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
