<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplyContextType StructType
 * @subpackage Structs
 */
class ReplyContextType extends AbstractStructBase
{
    /**
     * The RequestId
     * @var string
     */
    public $RequestId;
    /**
     * The ReplyId
     * @var string
     */
    public $ReplyId;
    /**
     * The ReplyStatus
     * @var \StructType\ReplyStatusType
     */
    public $ReplyStatus;
    /**
     * The AccountBalance
     * @var int
     */
    public $AccountBalance;
    /**
     * The SnapshotDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SnapshotDate;
    /**
     * Constructor method for ReplyContextType
     * @uses ReplyContextType::setRequestId()
     * @uses ReplyContextType::setReplyId()
     * @uses ReplyContextType::setReplyStatus()
     * @uses ReplyContextType::setAccountBalance()
     * @uses ReplyContextType::setSnapshotDate()
     * @param string $requestId
     * @param string $replyId
     * @param \StructType\ReplyStatusType $replyStatus
     * @param int $accountBalance
     * @param string $snapshotDate
     */
    public function __construct($requestId = null, $replyId = null, \StructType\ReplyStatusType $replyStatus = null, $accountBalance = null, $snapshotDate = null)
    {
        $this
            ->setRequestId($requestId)
            ->setReplyId($replyId)
            ->setReplyStatus($replyStatus)
            ->setAccountBalance($accountBalance)
            ->setSnapshotDate($snapshotDate);
    }
    /**
     * Get RequestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param string $requestId
     * @return \StructType\ReplyContextType
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
    /**
     * Get ReplyId value
     * @return string|null
     */
    public function getReplyId()
    {
        return $this->ReplyId;
    }
    /**
     * Set ReplyId value
     * @param string $replyId
     * @return \StructType\ReplyContextType
     */
    public function setReplyId($replyId = null)
    {
        // validation for constraint: string
        if (!is_null($replyId) && !is_string($replyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replyId, true), gettype($replyId)), __LINE__);
        }
        $this->ReplyId = $replyId;
        return $this;
    }
    /**
     * Get ReplyStatus value
     * @return \StructType\ReplyStatusType|null
     */
    public function getReplyStatus()
    {
        return $this->ReplyStatus;
    }
    /**
     * Set ReplyStatus value
     * @param \StructType\ReplyStatusType $replyStatus
     * @return \StructType\ReplyContextType
     */
    public function setReplyStatus(\StructType\ReplyStatusType $replyStatus = null)
    {
        $this->ReplyStatus = $replyStatus;
        return $this;
    }
    /**
     * Get AccountBalance value
     * @return int|null
     */
    public function getAccountBalance()
    {
        return $this->AccountBalance;
    }
    /**
     * Set AccountBalance value
     * @param int $accountBalance
     * @return \StructType\ReplyContextType
     */
    public function setAccountBalance($accountBalance = null)
    {
        // validation for constraint: int
        if (!is_null($accountBalance) && !(is_int($accountBalance) || ctype_digit($accountBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountBalance, true), gettype($accountBalance)), __LINE__);
        }
        $this->AccountBalance = $accountBalance;
        return $this;
    }
    /**
     * Get SnapshotDate value
     * @return string|null
     */
    public function getSnapshotDate()
    {
        return $this->SnapshotDate;
    }
    /**
     * Set SnapshotDate value
     * @param string $snapshotDate
     * @return \StructType\ReplyContextType
     */
    public function setSnapshotDate($snapshotDate = null)
    {
        // validation for constraint: string
        if (!is_null($snapshotDate) && !is_string($snapshotDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($snapshotDate, true), gettype($snapshotDate)), __LINE__);
        }
        $this->SnapshotDate = $snapshotDate;
        return $this;
    }
}
