<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZipcodeLocationFilterType StructType
 * @subpackage Structs
 */
class ZipcodeLocationFilterType extends AbstractStructBase
{
    /**
     * The Zipcode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 4
     * - maxOccurs: 4
     * - pattern: \d{4}
     * @var string[]
     */
    public $Zipcode;
    /**
     * Constructor method for ZipcodeLocationFilterType
     * @uses ZipcodeLocationFilterType::setZipcode()
     * @param string[] $zipcode
     */
    public function __construct(array $zipcode = array())
    {
        $this
            ->setZipcode($zipcode);
    }
    /**
     * Get Zipcode value
     * @return string[]|null
     */
    public function getZipcode()
    {
        return $this->Zipcode;
    }
    /**
     * This method is responsible for validating the values passed to the setZipcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZipcode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZipcodeForArrayConstraintsFromSetZipcode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zipcodeLocationFilterTypeZipcodeItem) {
            // validation for constraint: itemType
            if (!is_string($zipcodeLocationFilterTypeZipcodeItem)) {
                $invalidValues[] = is_object($zipcodeLocationFilterTypeZipcodeItem) ? get_class($zipcodeLocationFilterTypeZipcodeItem) : sprintf('%s(%s)', gettype($zipcodeLocationFilterTypeZipcodeItem), var_export($zipcodeLocationFilterTypeZipcodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Zipcode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setZipcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZipcode method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZipcodeForLengthConstraintFromSetZipcode($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zipcodeLocationFilterTypeZipcodeItem) {
            // validation for constraint: length(4)
            if (mb_strlen($zipcodeLocationFilterTypeZipcodeItem) !== 4) {
                $invalidValues[] = var_export($zipcodeLocationFilterTypeZipcodeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 4', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Zipcode value
     * @throws \InvalidArgumentException
     * @param string[] $zipcode
     * @return \StructType\ZipcodeLocationFilterType
     */
    public function setZipcode(array $zipcode = array())
    {
        // validation for constraint: array
        if ('' !== ($zipcodeArrayErrorMessage = self::validateZipcodeForArrayConstraintsFromSetZipcode($zipcode))) {
            throw new \InvalidArgumentException($zipcodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(4)
        if ('' !== ($zipcodeLengthErrorMessage = self::validateZipcodeForLengthConstraintFromSetZipcode($zipcode))) {
            throw new \InvalidArgumentException($zipcodeLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($zipcode) && count($zipcode) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($zipcode)), __LINE__);
        }
        // validation for constraint: pattern(\d{4})
        if (!is_null($zipcode) && !preg_match('/\\d{4}/', $zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}', var_export($zipcode, true)), __LINE__);
        }
        $this->Zipcode = $zipcode;
        return $this;
    }
    /**
     * Add item to Zipcode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ZipcodeLocationFilterType
     */
    public function addToZipcode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Zipcode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(4)
        if (mb_strlen($item) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->Zipcode) && count($this->Zipcode) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->Zipcode)), __LINE__);
        }
        // validation for constraint: pattern(\d{4})
        if (!preg_match('/\\d{4}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}', var_export($item, true)), __LINE__);
        }
        $this->Zipcode[] = $item;
        return $this;
    }
}
