<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadEstablishmentByNameExactMatchRequestType StructType
 * @subpackage Structs
 */
class ReadEstablishmentByNameExactMatchRequestType extends AbstractStructBase
{
    /**
     * The EstablishmentName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 160
     * - whiteSpace: collapse
     * @var string
     */
    public $EstablishmentName;
    /**
     * The Zipcode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 4
     * - minOccurs: 0
     * - pattern: \d{4}
     * @var string
     */
    public $Zipcode;
    /**
     * The ActiveFilter
     * @var bool
     */
    public $ActiveFilter;
    /**
     * Constructor method for ReadEstablishmentByNameExactMatchRequestType
     * @uses ReadEstablishmentByNameExactMatchRequestType::setEstablishmentName()
     * @uses ReadEstablishmentByNameExactMatchRequestType::setZipcode()
     * @uses ReadEstablishmentByNameExactMatchRequestType::setActiveFilter()
     * @param string $establishmentName
     * @param string $zipcode
     * @param bool $activeFilter
     */
    public function __construct($establishmentName = null, $zipcode = null, $activeFilter = null)
    {
        $this
            ->setEstablishmentName($establishmentName)
            ->setZipcode($zipcode)
            ->setActiveFilter($activeFilter);
    }
    /**
     * Get EstablishmentName value
     * @return string|null
     */
    public function getEstablishmentName()
    {
        return $this->EstablishmentName;
    }
    /**
     * Set EstablishmentName value
     * @param string $establishmentName
     * @return \StructType\ReadEstablishmentByNameExactMatchRequestType
     */
    public function setEstablishmentName($establishmentName = null)
    {
        // validation for constraint: string
        if (!is_null($establishmentName) && !is_string($establishmentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($establishmentName, true), gettype($establishmentName)), __LINE__);
        }
        // validation for constraint: maxLength(160)
        if (!is_null($establishmentName) && mb_strlen($establishmentName) > 160) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 160', mb_strlen($establishmentName)), __LINE__);
        }
        $this->EstablishmentName = $establishmentName;
        return $this;
    }
    /**
     * Get Zipcode value
     * @return string|null
     */
    public function getZipcode()
    {
        return $this->Zipcode;
    }
    /**
     * Set Zipcode value
     * @param string $zipcode
     * @return \StructType\ReadEstablishmentByNameExactMatchRequestType
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($zipcode) && mb_strlen($zipcode) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($zipcode)), __LINE__);
        }
        // validation for constraint: pattern(\d{4})
        if (!is_null($zipcode) && !preg_match('/\\d{4}/', $zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}', var_export($zipcode, true)), __LINE__);
        }
        $this->Zipcode = $zipcode;
        return $this;
    }
    /**
     * Get ActiveFilter value
     * @return bool|null
     */
    public function getActiveFilter()
    {
        return $this->ActiveFilter;
    }
    /**
     * Set ActiveFilter value
     * @param bool $activeFilter
     * @return \StructType\ReadEstablishmentByNameExactMatchRequestType
     */
    public function setActiveFilter($activeFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeFilter) && !is_bool($activeFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeFilter, true), gettype($activeFilter)), __LINE__);
        }
        $this->ActiveFilter = $activeFilter;
        return $this;
    }
}
