<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonType StructType
 * @subpackage Structs
 */
class PersonType extends AbstractStructBase
{
    /**
     * The Surname
     * @var string
     */
    public $Surname;
    /**
     * The GivenName
     * @var string
     */
    public $GivenName;
    /**
     * Constructor method for PersonType
     * @uses PersonType::setSurname()
     * @uses PersonType::setGivenName()
     * @param string $surname
     * @param string $givenName
     */
    public function __construct($surname = null, $givenName = null)
    {
        $this
            ->setSurname($surname)
            ->setGivenName($givenName);
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\PersonType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * Set GivenName value
     * @param string $givenName
     * @return \StructType\PersonType
     */
    public function setGivenName($givenName = null)
    {
        // validation for constraint: string
        if (!is_null($givenName) && !is_string($givenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($givenName, true), gettype($givenName)), __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
}
