<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JuridicalFormCACType StructType
 * @subpackage Structs
 */
class JuridicalFormCACType extends AbstractStructBase
{
    /**
     * The CACDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CACDate;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\DescriptionType[]
     */
    public $Description;
    /**
     * Constructor method for JuridicalFormCACType
     * @uses JuridicalFormCACType::setCACDate()
     * @uses JuridicalFormCACType::setCode()
     * @uses JuridicalFormCACType::setDescription()
     * @param string $cACDate
     * @param string $code
     * @param \StructType\DescriptionType[] $description
     */
    public function __construct($cACDate = null, $code = null, array $description = array())
    {
        $this
            ->setCACDate($cACDate)
            ->setCode($code)
            ->setDescription($description);
    }
    /**
     * Get CACDate value
     * @return string
     */
    public function getCACDate()
    {
        return $this->CACDate;
    }
    /**
     * Set CACDate value
     * @param string $cACDate
     * @return \StructType\JuridicalFormCACType
     */
    public function setCACDate($cACDate = null)
    {
        // validation for constraint: string
        if (!is_null($cACDate) && !is_string($cACDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cACDate, true), gettype($cACDate)), __LINE__);
        }
        $this->CACDate = $cACDate;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JuridicalFormCACType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $juridicalFormCACTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$juridicalFormCACTypeDescriptionItem instanceof \StructType\DescriptionType) {
                $invalidValues[] = is_object($juridicalFormCACTypeDescriptionItem) ? get_class($juridicalFormCACTypeDescriptionItem) : sprintf('%s(%s)', gettype($juridicalFormCACTypeDescriptionItem), var_export($juridicalFormCACTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType[] $description
     * @return \StructType\JuridicalFormCACType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType $item
     * @return \StructType\JuridicalFormCACType
     */
    public function addToDescription(\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
}
