<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnterpriseType StructType
 * @subpackage Structs
 */
class EnterpriseType extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - base: xs:long
     * - pattern: [01]?[0-9]{9}
     * @var int
     */
    public $Number;
    /**
     * The JuridicalSituation
     * @var \StructType\JuridicalSituationType
     */
    public $JuridicalSituation;
    /**
     * The Period
     * @var \StructType\PeriodType
     */
    public $Period;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Duration;
    /**
     * The TypeOfEnterprise
     * @var string
     */
    public $TypeOfEnterprise;
    /**
     * The JuridicalForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JuridicalFormType
     */
    public $JuridicalForm;
    /**
     * The Capital
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CapitalType
     */
    public $Capital;
    /**
     * The PrimaryDenomination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DescriptionType[]
     */
    public $PrimaryDenomination;
    /**
     * The Denomination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DenominationType[]
     */
    public $Denomination;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\AddressType[]
     */
    public $Address;
    /**
     * The ContactInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInformationType[]
     */
    public $ContactInformation;
    /**
     * The BusinessUnits
     * @var int
     */
    public $BusinessUnits;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BranchType[]
     */
    public $Branch;
    /**
     * The ProfessionalCompetence
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProfessionalCompetenceType[]
     */
    public $ProfessionalCompetence;
    /**
     * The Qualification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\QualificationType[]
     */
    public $Qualification;
    /**
     * The Authorization
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AuthorizationType[]
     */
    public $Authorization;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ActivityType[]
     */
    public $Activity;
    /**
     * The Function
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FunctionType[]
     */
    public $Function;
    /**
     * The LinkedEnterprise
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LinkedEnterpriseType[]
     */
    public $LinkedEnterprise;
    /**
     * The FinancialData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FinancialDataType
     */
    public $FinancialData;
    /**
     * The Replacement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReplacementType[]
     */
    public $Replacement;
    /**
     * The ExOfficioStrikingOff
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExOfficioStrikingOffType[]
     */
    public $ExOfficioStrikingOff;
    /**
     * Constructor method for EnterpriseType
     * @uses EnterpriseType::setNumber()
     * @uses EnterpriseType::setJuridicalSituation()
     * @uses EnterpriseType::setPeriod()
     * @uses EnterpriseType::setDuration()
     * @uses EnterpriseType::setTypeOfEnterprise()
     * @uses EnterpriseType::setJuridicalForm()
     * @uses EnterpriseType::setCapital()
     * @uses EnterpriseType::setPrimaryDenomination()
     * @uses EnterpriseType::setDenomination()
     * @uses EnterpriseType::setAddress()
     * @uses EnterpriseType::setContactInformation()
     * @uses EnterpriseType::setBusinessUnits()
     * @uses EnterpriseType::setBranch()
     * @uses EnterpriseType::setProfessionalCompetence()
     * @uses EnterpriseType::setQualification()
     * @uses EnterpriseType::setAuthorization()
     * @uses EnterpriseType::setActivity()
     * @uses EnterpriseType::setFunction()
     * @uses EnterpriseType::setLinkedEnterprise()
     * @uses EnterpriseType::setFinancialData()
     * @uses EnterpriseType::setReplacement()
     * @uses EnterpriseType::setExOfficioStrikingOff()
     * @param int $number
     * @param \StructType\JuridicalSituationType $juridicalSituation
     * @param \StructType\PeriodType $period
     * @param int $duration
     * @param string $typeOfEnterprise
     * @param \StructType\JuridicalFormType $juridicalForm
     * @param \StructType\CapitalType $capital
     * @param \StructType\DescriptionType[] $primaryDenomination
     * @param \StructType\DenominationType[] $denomination
     * @param \StructType\AddressType[] $address
     * @param \StructType\ContactInformationType[] $contactInformation
     * @param int $businessUnits
     * @param \StructType\BranchType[] $branch
     * @param \StructType\ProfessionalCompetenceType[] $professionalCompetence
     * @param \StructType\QualificationType[] $qualification
     * @param \StructType\AuthorizationType[] $authorization
     * @param \StructType\ActivityType[] $activity
     * @param \StructType\FunctionType[] $function
     * @param \StructType\LinkedEnterpriseType[] $linkedEnterprise
     * @param \StructType\FinancialDataType $financialData
     * @param \StructType\ReplacementType[] $replacement
     * @param \StructType\ExOfficioStrikingOffType[] $exOfficioStrikingOff
     */
    public function __construct($number = null, \StructType\JuridicalSituationType $juridicalSituation = null, \StructType\PeriodType $period = null, $duration = null, $typeOfEnterprise = null, \StructType\JuridicalFormType $juridicalForm = null, \StructType\CapitalType $capital = null, array $primaryDenomination = array(), array $denomination = array(), array $address = array(), array $contactInformation = array(), $businessUnits = null, array $branch = array(), array $professionalCompetence = array(), array $qualification = array(), array $authorization = array(), array $activity = array(), array $function = array(), array $linkedEnterprise = array(), \StructType\FinancialDataType $financialData = null, array $replacement = array(), array $exOfficioStrikingOff = array())
    {
        $this
            ->setNumber($number)
            ->setJuridicalSituation($juridicalSituation)
            ->setPeriod($period)
            ->setDuration($duration)
            ->setTypeOfEnterprise($typeOfEnterprise)
            ->setJuridicalForm($juridicalForm)
            ->setCapital($capital)
            ->setPrimaryDenomination($primaryDenomination)
            ->setDenomination($denomination)
            ->setAddress($address)
            ->setContactInformation($contactInformation)
            ->setBusinessUnits($businessUnits)
            ->setBranch($branch)
            ->setProfessionalCompetence($professionalCompetence)
            ->setQualification($qualification)
            ->setAuthorization($authorization)
            ->setActivity($activity)
            ->setFunction($function)
            ->setLinkedEnterprise($linkedEnterprise)
            ->setFinancialData($financialData)
            ->setReplacement($replacement)
            ->setExOfficioStrikingOff($exOfficioStrikingOff);
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\EnterpriseType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: pattern([01]?[0-9]{9})
        if (!is_null($number) && !preg_match('/[01]?[0-9]{9}/', $number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [01]?[0-9]{9}', var_export($number, true)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get JuridicalSituation value
     * @return \StructType\JuridicalSituationType|null
     */
    public function getJuridicalSituation()
    {
        return $this->JuridicalSituation;
    }
    /**
     * Set JuridicalSituation value
     * @param \StructType\JuridicalSituationType $juridicalSituation
     * @return \StructType\EnterpriseType
     */
    public function setJuridicalSituation(\StructType\JuridicalSituationType $juridicalSituation = null)
    {
        $this->JuridicalSituation = $juridicalSituation;
        return $this;
    }
    /**
     * Get Period value
     * @return \StructType\PeriodType|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \StructType\PeriodType $period
     * @return \StructType\EnterpriseType
     */
    public function setPeriod(\StructType\PeriodType $period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Get Duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\EnterpriseType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get TypeOfEnterprise value
     * @return string|null
     */
    public function getTypeOfEnterprise()
    {
        return $this->TypeOfEnterprise;
    }
    /**
     * Set TypeOfEnterprise value
     * @uses \EnumType\Type::valueIsValid()
     * @uses \EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfEnterprise
     * @return \StructType\EnterpriseType
     */
    public function setTypeOfEnterprise($typeOfEnterprise = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Type::valueIsValid($typeOfEnterprise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Type', is_array($typeOfEnterprise) ? implode(', ', $typeOfEnterprise) : var_export($typeOfEnterprise, true), implode(', ', \EnumType\Type::getValidValues())), __LINE__);
        }
        $this->TypeOfEnterprise = $typeOfEnterprise;
        return $this;
    }
    /**
     * Get JuridicalForm value
     * @return \StructType\JuridicalFormType|null
     */
    public function getJuridicalForm()
    {
        return $this->JuridicalForm;
    }
    /**
     * Set JuridicalForm value
     * @param \StructType\JuridicalFormType $juridicalForm
     * @return \StructType\EnterpriseType
     */
    public function setJuridicalForm(\StructType\JuridicalFormType $juridicalForm = null)
    {
        $this->JuridicalForm = $juridicalForm;
        return $this;
    }
    /**
     * Get Capital value
     * @return \StructType\CapitalType|null
     */
    public function getCapital()
    {
        return $this->Capital;
    }
    /**
     * Set Capital value
     * @param \StructType\CapitalType $capital
     * @return \StructType\EnterpriseType
     */
    public function setCapital(\StructType\CapitalType $capital = null)
    {
        $this->Capital = $capital;
        return $this;
    }
    /**
     * Get PrimaryDenomination value
     * @return \StructType\DescriptionType[]|null
     */
    public function getPrimaryDenomination()
    {
        return $this->PrimaryDenomination;
    }
    /**
     * This method is responsible for validating the values passed to the setPrimaryDenomination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrimaryDenomination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrimaryDenominationForArrayConstraintsFromSetPrimaryDenomination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypePrimaryDenominationItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypePrimaryDenominationItem instanceof \StructType\DescriptionType) {
                $invalidValues[] = is_object($enterpriseTypePrimaryDenominationItem) ? get_class($enterpriseTypePrimaryDenominationItem) : sprintf('%s(%s)', gettype($enterpriseTypePrimaryDenominationItem), var_export($enterpriseTypePrimaryDenominationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PrimaryDenomination property can only contain items of type \StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PrimaryDenomination value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType[] $primaryDenomination
     * @return \StructType\EnterpriseType
     */
    public function setPrimaryDenomination(array $primaryDenomination = array())
    {
        // validation for constraint: array
        if ('' !== ($primaryDenominationArrayErrorMessage = self::validatePrimaryDenominationForArrayConstraintsFromSetPrimaryDenomination($primaryDenomination))) {
            throw new \InvalidArgumentException($primaryDenominationArrayErrorMessage, __LINE__);
        }
        $this->PrimaryDenomination = $primaryDenomination;
        return $this;
    }
    /**
     * Add item to PrimaryDenomination value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType $item
     * @return \StructType\EnterpriseType
     */
    public function addToPrimaryDenomination(\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The PrimaryDenomination property can only contain items of type \StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PrimaryDenomination[] = $item;
        return $this;
    }
    /**
     * Get Denomination value
     * @return \StructType\DenominationType[]|null
     */
    public function getDenomination()
    {
        return $this->Denomination;
    }
    /**
     * This method is responsible for validating the values passed to the setDenomination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDenomination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDenominationForArrayConstraintsFromSetDenomination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeDenominationItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeDenominationItem instanceof \StructType\DenominationType) {
                $invalidValues[] = is_object($enterpriseTypeDenominationItem) ? get_class($enterpriseTypeDenominationItem) : sprintf('%s(%s)', gettype($enterpriseTypeDenominationItem), var_export($enterpriseTypeDenominationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Denomination property can only contain items of type \StructType\DenominationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Denomination value
     * @throws \InvalidArgumentException
     * @param \StructType\DenominationType[] $denomination
     * @return \StructType\EnterpriseType
     */
    public function setDenomination(array $denomination = array())
    {
        // validation for constraint: array
        if ('' !== ($denominationArrayErrorMessage = self::validateDenominationForArrayConstraintsFromSetDenomination($denomination))) {
            throw new \InvalidArgumentException($denominationArrayErrorMessage, __LINE__);
        }
        $this->Denomination = $denomination;
        return $this;
    }
    /**
     * Add item to Denomination value
     * @throws \InvalidArgumentException
     * @param \StructType\DenominationType $item
     * @return \StructType\EnterpriseType
     */
    public function addToDenomination(\StructType\DenominationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DenominationType) {
            throw new \InvalidArgumentException(sprintf('The Denomination property can only contain items of type \StructType\DenominationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Denomination[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeAddressItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeAddressItem instanceof \StructType\AddressType) {
                $invalidValues[] = is_object($enterpriseTypeAddressItem) ? get_class($enterpriseTypeAddressItem) : sprintf('%s(%s)', gettype($enterpriseTypeAddressItem), var_export($enterpriseTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \StructType\AddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressType[] $address
     * @return \StructType\EnterpriseType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($address) && count($address) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressType $item
     * @return \StructType\EnterpriseType
     */
    public function addToAddress(\StructType\AddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressType) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \StructType\AddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->Address) && count($this->Address) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->Address)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get ContactInformation value
     * @return \StructType\ContactInformationType[]|null
     */
    public function getContactInformation()
    {
        return $this->ContactInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInformationForArrayConstraintsFromSetContactInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeContactInformationItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeContactInformationItem instanceof \StructType\ContactInformationType) {
                $invalidValues[] = is_object($enterpriseTypeContactInformationItem) ? get_class($enterpriseTypeContactInformationItem) : sprintf('%s(%s)', gettype($enterpriseTypeContactInformationItem), var_export($enterpriseTypeContactInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInformation property can only contain items of type \StructType\ContactInformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInformationType[] $contactInformation
     * @return \StructType\EnterpriseType
     */
    public function setContactInformation(array $contactInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInformationArrayErrorMessage = self::validateContactInformationForArrayConstraintsFromSetContactInformation($contactInformation))) {
            throw new \InvalidArgumentException($contactInformationArrayErrorMessage, __LINE__);
        }
        $this->ContactInformation = $contactInformation;
        return $this;
    }
    /**
     * Add item to ContactInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInformationType $item
     * @return \StructType\EnterpriseType
     */
    public function addToContactInformation(\StructType\ContactInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInformationType) {
            throw new \InvalidArgumentException(sprintf('The ContactInformation property can only contain items of type \StructType\ContactInformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInformation[] = $item;
        return $this;
    }
    /**
     * Get BusinessUnits value
     * @return int|null
     */
    public function getBusinessUnits()
    {
        return $this->BusinessUnits;
    }
    /**
     * Set BusinessUnits value
     * @param int $businessUnits
     * @return \StructType\EnterpriseType
     */
    public function setBusinessUnits($businessUnits = null)
    {
        // validation for constraint: int
        if (!is_null($businessUnits) && !(is_int($businessUnits) || ctype_digit($businessUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessUnits, true), gettype($businessUnits)), __LINE__);
        }
        $this->BusinessUnits = $businessUnits;
        return $this;
    }
    /**
     * Get Branch value
     * @return \StructType\BranchType[]|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * This method is responsible for validating the values passed to the setBranch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBranch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBranchForArrayConstraintsFromSetBranch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeBranchItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeBranchItem instanceof \StructType\BranchType) {
                $invalidValues[] = is_object($enterpriseTypeBranchItem) ? get_class($enterpriseTypeBranchItem) : sprintf('%s(%s)', gettype($enterpriseTypeBranchItem), var_export($enterpriseTypeBranchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Branch property can only contain items of type \StructType\BranchType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Branch value
     * @throws \InvalidArgumentException
     * @param \StructType\BranchType[] $branch
     * @return \StructType\EnterpriseType
     */
    public function setBranch(array $branch = array())
    {
        // validation for constraint: array
        if ('' !== ($branchArrayErrorMessage = self::validateBranchForArrayConstraintsFromSetBranch($branch))) {
            throw new \InvalidArgumentException($branchArrayErrorMessage, __LINE__);
        }
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Add item to Branch value
     * @throws \InvalidArgumentException
     * @param \StructType\BranchType $item
     * @return \StructType\EnterpriseType
     */
    public function addToBranch(\StructType\BranchType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BranchType) {
            throw new \InvalidArgumentException(sprintf('The Branch property can only contain items of type \StructType\BranchType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Branch[] = $item;
        return $this;
    }
    /**
     * Get ProfessionalCompetence value
     * @return \StructType\ProfessionalCompetenceType[]|null
     */
    public function getProfessionalCompetence()
    {
        return $this->ProfessionalCompetence;
    }
    /**
     * This method is responsible for validating the values passed to the setProfessionalCompetence method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfessionalCompetence method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfessionalCompetenceForArrayConstraintsFromSetProfessionalCompetence(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeProfessionalCompetenceItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeProfessionalCompetenceItem instanceof \StructType\ProfessionalCompetenceType) {
                $invalidValues[] = is_object($enterpriseTypeProfessionalCompetenceItem) ? get_class($enterpriseTypeProfessionalCompetenceItem) : sprintf('%s(%s)', gettype($enterpriseTypeProfessionalCompetenceItem), var_export($enterpriseTypeProfessionalCompetenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProfessionalCompetence property can only contain items of type \StructType\ProfessionalCompetenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProfessionalCompetence value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfessionalCompetenceType[] $professionalCompetence
     * @return \StructType\EnterpriseType
     */
    public function setProfessionalCompetence(array $professionalCompetence = array())
    {
        // validation for constraint: array
        if ('' !== ($professionalCompetenceArrayErrorMessage = self::validateProfessionalCompetenceForArrayConstraintsFromSetProfessionalCompetence($professionalCompetence))) {
            throw new \InvalidArgumentException($professionalCompetenceArrayErrorMessage, __LINE__);
        }
        $this->ProfessionalCompetence = $professionalCompetence;
        return $this;
    }
    /**
     * Add item to ProfessionalCompetence value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfessionalCompetenceType $item
     * @return \StructType\EnterpriseType
     */
    public function addToProfessionalCompetence(\StructType\ProfessionalCompetenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProfessionalCompetenceType) {
            throw new \InvalidArgumentException(sprintf('The ProfessionalCompetence property can only contain items of type \StructType\ProfessionalCompetenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProfessionalCompetence[] = $item;
        return $this;
    }
    /**
     * Get Qualification value
     * @return \StructType\QualificationType[]|null
     */
    public function getQualification()
    {
        return $this->Qualification;
    }
    /**
     * This method is responsible for validating the values passed to the setQualification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQualification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQualificationForArrayConstraintsFromSetQualification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeQualificationItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeQualificationItem instanceof \StructType\QualificationType) {
                $invalidValues[] = is_object($enterpriseTypeQualificationItem) ? get_class($enterpriseTypeQualificationItem) : sprintf('%s(%s)', gettype($enterpriseTypeQualificationItem), var_export($enterpriseTypeQualificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Qualification property can only contain items of type \StructType\QualificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Qualification value
     * @throws \InvalidArgumentException
     * @param \StructType\QualificationType[] $qualification
     * @return \StructType\EnterpriseType
     */
    public function setQualification(array $qualification = array())
    {
        // validation for constraint: array
        if ('' !== ($qualificationArrayErrorMessage = self::validateQualificationForArrayConstraintsFromSetQualification($qualification))) {
            throw new \InvalidArgumentException($qualificationArrayErrorMessage, __LINE__);
        }
        $this->Qualification = $qualification;
        return $this;
    }
    /**
     * Add item to Qualification value
     * @throws \InvalidArgumentException
     * @param \StructType\QualificationType $item
     * @return \StructType\EnterpriseType
     */
    public function addToQualification(\StructType\QualificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QualificationType) {
            throw new \InvalidArgumentException(sprintf('The Qualification property can only contain items of type \StructType\QualificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Qualification[] = $item;
        return $this;
    }
    /**
     * Get Authorization value
     * @return \StructType\AuthorizationType[]|null
     */
    public function getAuthorization()
    {
        return $this->Authorization;
    }
    /**
     * This method is responsible for validating the values passed to the setAuthorization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorization method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuthorizationForArrayConstraintsFromSetAuthorization(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeAuthorizationItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeAuthorizationItem instanceof \StructType\AuthorizationType) {
                $invalidValues[] = is_object($enterpriseTypeAuthorizationItem) ? get_class($enterpriseTypeAuthorizationItem) : sprintf('%s(%s)', gettype($enterpriseTypeAuthorizationItem), var_export($enterpriseTypeAuthorizationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Authorization property can only contain items of type \StructType\AuthorizationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Authorization value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizationType[] $authorization
     * @return \StructType\EnterpriseType
     */
    public function setAuthorization(array $authorization = array())
    {
        // validation for constraint: array
        if ('' !== ($authorizationArrayErrorMessage = self::validateAuthorizationForArrayConstraintsFromSetAuthorization($authorization))) {
            throw new \InvalidArgumentException($authorizationArrayErrorMessage, __LINE__);
        }
        $this->Authorization = $authorization;
        return $this;
    }
    /**
     * Add item to Authorization value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizationType $item
     * @return \StructType\EnterpriseType
     */
    public function addToAuthorization(\StructType\AuthorizationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AuthorizationType) {
            throw new \InvalidArgumentException(sprintf('The Authorization property can only contain items of type \StructType\AuthorizationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Authorization[] = $item;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\ActivityType[]|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * This method is responsible for validating the values passed to the setActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityForArrayConstraintsFromSetActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeActivityItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeActivityItem instanceof \StructType\ActivityType) {
                $invalidValues[] = is_object($enterpriseTypeActivityItem) ? get_class($enterpriseTypeActivityItem) : sprintf('%s(%s)', gettype($enterpriseTypeActivityItem), var_export($enterpriseTypeActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Activity property can only contain items of type \StructType\ActivityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Activity value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityType[] $activity
     * @return \StructType\EnterpriseType
     */
    public function setActivity(array $activity = array())
    {
        // validation for constraint: array
        if ('' !== ($activityArrayErrorMessage = self::validateActivityForArrayConstraintsFromSetActivity($activity))) {
            throw new \InvalidArgumentException($activityArrayErrorMessage, __LINE__);
        }
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Add item to Activity value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityType $item
     * @return \StructType\EnterpriseType
     */
    public function addToActivity(\StructType\ActivityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityType) {
            throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of type \StructType\ActivityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Activity[] = $item;
        return $this;
    }
    /**
     * Get Function value
     * @return \StructType\FunctionType[]|null
     */
    public function getFunction()
    {
        return $this->Function;
    }
    /**
     * This method is responsible for validating the values passed to the setFunction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFunction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFunctionForArrayConstraintsFromSetFunction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeFunctionItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeFunctionItem instanceof \StructType\FunctionType) {
                $invalidValues[] = is_object($enterpriseTypeFunctionItem) ? get_class($enterpriseTypeFunctionItem) : sprintf('%s(%s)', gettype($enterpriseTypeFunctionItem), var_export($enterpriseTypeFunctionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Function property can only contain items of type \StructType\FunctionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Function value
     * @throws \InvalidArgumentException
     * @param \StructType\FunctionType[] $function
     * @return \StructType\EnterpriseType
     */
    public function setFunction(array $function = array())
    {
        // validation for constraint: array
        if ('' !== ($functionArrayErrorMessage = self::validateFunctionForArrayConstraintsFromSetFunction($function))) {
            throw new \InvalidArgumentException($functionArrayErrorMessage, __LINE__);
        }
        $this->Function = $function;
        return $this;
    }
    /**
     * Add item to Function value
     * @throws \InvalidArgumentException
     * @param \StructType\FunctionType $item
     * @return \StructType\EnterpriseType
     */
    public function addToFunction(\StructType\FunctionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FunctionType) {
            throw new \InvalidArgumentException(sprintf('The Function property can only contain items of type \StructType\FunctionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Function[] = $item;
        return $this;
    }
    /**
     * Get LinkedEnterprise value
     * @return \StructType\LinkedEnterpriseType[]|null
     */
    public function getLinkedEnterprise()
    {
        return $this->LinkedEnterprise;
    }
    /**
     * This method is responsible for validating the values passed to the setLinkedEnterprise method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLinkedEnterprise method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLinkedEnterpriseForArrayConstraintsFromSetLinkedEnterprise(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeLinkedEnterpriseItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeLinkedEnterpriseItem instanceof \StructType\LinkedEnterpriseType) {
                $invalidValues[] = is_object($enterpriseTypeLinkedEnterpriseItem) ? get_class($enterpriseTypeLinkedEnterpriseItem) : sprintf('%s(%s)', gettype($enterpriseTypeLinkedEnterpriseItem), var_export($enterpriseTypeLinkedEnterpriseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LinkedEnterprise property can only contain items of type \StructType\LinkedEnterpriseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LinkedEnterprise value
     * @throws \InvalidArgumentException
     * @param \StructType\LinkedEnterpriseType[] $linkedEnterprise
     * @return \StructType\EnterpriseType
     */
    public function setLinkedEnterprise(array $linkedEnterprise = array())
    {
        // validation for constraint: array
        if ('' !== ($linkedEnterpriseArrayErrorMessage = self::validateLinkedEnterpriseForArrayConstraintsFromSetLinkedEnterprise($linkedEnterprise))) {
            throw new \InvalidArgumentException($linkedEnterpriseArrayErrorMessage, __LINE__);
        }
        $this->LinkedEnterprise = $linkedEnterprise;
        return $this;
    }
    /**
     * Add item to LinkedEnterprise value
     * @throws \InvalidArgumentException
     * @param \StructType\LinkedEnterpriseType $item
     * @return \StructType\EnterpriseType
     */
    public function addToLinkedEnterprise(\StructType\LinkedEnterpriseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LinkedEnterpriseType) {
            throw new \InvalidArgumentException(sprintf('The LinkedEnterprise property can only contain items of type \StructType\LinkedEnterpriseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LinkedEnterprise[] = $item;
        return $this;
    }
    /**
     * Get FinancialData value
     * @return \StructType\FinancialDataType|null
     */
    public function getFinancialData()
    {
        return $this->FinancialData;
    }
    /**
     * Set FinancialData value
     * @param \StructType\FinancialDataType $financialData
     * @return \StructType\EnterpriseType
     */
    public function setFinancialData(\StructType\FinancialDataType $financialData = null)
    {
        $this->FinancialData = $financialData;
        return $this;
    }
    /**
     * Get Replacement value
     * @return \StructType\ReplacementType[]|null
     */
    public function getReplacement()
    {
        return $this->Replacement;
    }
    /**
     * This method is responsible for validating the values passed to the setReplacement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReplacement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReplacementForArrayConstraintsFromSetReplacement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeReplacementItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeReplacementItem instanceof \StructType\ReplacementType) {
                $invalidValues[] = is_object($enterpriseTypeReplacementItem) ? get_class($enterpriseTypeReplacementItem) : sprintf('%s(%s)', gettype($enterpriseTypeReplacementItem), var_export($enterpriseTypeReplacementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Replacement property can only contain items of type \StructType\ReplacementType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Replacement value
     * @throws \InvalidArgumentException
     * @param \StructType\ReplacementType[] $replacement
     * @return \StructType\EnterpriseType
     */
    public function setReplacement(array $replacement = array())
    {
        // validation for constraint: array
        if ('' !== ($replacementArrayErrorMessage = self::validateReplacementForArrayConstraintsFromSetReplacement($replacement))) {
            throw new \InvalidArgumentException($replacementArrayErrorMessage, __LINE__);
        }
        $this->Replacement = $replacement;
        return $this;
    }
    /**
     * Add item to Replacement value
     * @throws \InvalidArgumentException
     * @param \StructType\ReplacementType $item
     * @return \StructType\EnterpriseType
     */
    public function addToReplacement(\StructType\ReplacementType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReplacementType) {
            throw new \InvalidArgumentException(sprintf('The Replacement property can only contain items of type \StructType\ReplacementType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Replacement[] = $item;
        return $this;
    }
    /**
     * Get ExOfficioStrikingOff value
     * @return \StructType\ExOfficioStrikingOffType[]|null
     */
    public function getExOfficioStrikingOff()
    {
        return $this->ExOfficioStrikingOff;
    }
    /**
     * This method is responsible for validating the values passed to the setExOfficioStrikingOff method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExOfficioStrikingOff method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExOfficioStrikingOffForArrayConstraintsFromSetExOfficioStrikingOff(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeExOfficioStrikingOffItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeExOfficioStrikingOffItem instanceof \StructType\ExOfficioStrikingOffType) {
                $invalidValues[] = is_object($enterpriseTypeExOfficioStrikingOffItem) ? get_class($enterpriseTypeExOfficioStrikingOffItem) : sprintf('%s(%s)', gettype($enterpriseTypeExOfficioStrikingOffItem), var_export($enterpriseTypeExOfficioStrikingOffItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExOfficioStrikingOff property can only contain items of type \StructType\ExOfficioStrikingOffType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExOfficioStrikingOff value
     * @throws \InvalidArgumentException
     * @param \StructType\ExOfficioStrikingOffType[] $exOfficioStrikingOff
     * @return \StructType\EnterpriseType
     */
    public function setExOfficioStrikingOff(array $exOfficioStrikingOff = array())
    {
        // validation for constraint: array
        if ('' !== ($exOfficioStrikingOffArrayErrorMessage = self::validateExOfficioStrikingOffForArrayConstraintsFromSetExOfficioStrikingOff($exOfficioStrikingOff))) {
            throw new \InvalidArgumentException($exOfficioStrikingOffArrayErrorMessage, __LINE__);
        }
        $this->ExOfficioStrikingOff = $exOfficioStrikingOff;
        return $this;
    }
    /**
     * Add item to ExOfficioStrikingOff value
     * @throws \InvalidArgumentException
     * @param \StructType\ExOfficioStrikingOffType $item
     * @return \StructType\EnterpriseType
     */
    public function addToExOfficioStrikingOff(\StructType\ExOfficioStrikingOffType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExOfficioStrikingOffType) {
            throw new \InvalidArgumentException(sprintf('The ExOfficioStrikingOff property can only contain items of type \StructType\ExOfficioStrikingOffType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExOfficioStrikingOff[] = $item;
        return $this;
    }
}
