<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BranchType StructType
 * @subpackage Structs
 */
class BranchType extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:long
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [09]?[0-9]{9}
     * @var int
     */
    public $Id;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\StatusType
     */
    public $Status;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\PeriodType
     */
    public $ValidityPeriod;
    /**
     * The Denomination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DenominationType[]
     */
    public $Denomination;
    /**
     * Constructor method for BranchType
     * @uses BranchType::setId()
     * @uses BranchType::setStatus()
     * @uses BranchType::setAddress()
     * @uses BranchType::setValidityPeriod()
     * @uses BranchType::setDenomination()
     * @param int $id
     * @param \StructType\StatusType $status
     * @param \StructType\AddressType $address
     * @param \StructType\PeriodType $validityPeriod
     * @param \StructType\DenominationType[] $denomination
     */
    public function __construct($id = null, \StructType\StatusType $status = null, \StructType\AddressType $address = null, \StructType\PeriodType $validityPeriod = null, array $denomination = array())
    {
        $this
            ->setId($id)
            ->setStatus($status)
            ->setAddress($address)
            ->setValidityPeriod($validityPeriod)
            ->setDenomination($denomination);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\BranchType
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([09]?[0-9]{9})
        if (!is_null($id) && !preg_match('/[09]?[0-9]{9}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [09]?[0-9]{9}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\StatusType
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\StatusType $status
     * @return \StructType\BranchType
     */
    public function setStatus(\StructType\StatusType $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\BranchType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \StructType\PeriodType
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \StructType\PeriodType $validityPeriod
     * @return \StructType\BranchType
     */
    public function setValidityPeriod(\StructType\PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get Denomination value
     * @return \StructType\DenominationType[]|null
     */
    public function getDenomination()
    {
        return $this->Denomination;
    }
    /**
     * This method is responsible for validating the values passed to the setDenomination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDenomination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDenominationForArrayConstraintsFromSetDenomination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $branchTypeDenominationItem) {
            // validation for constraint: itemType
            if (!$branchTypeDenominationItem instanceof \StructType\DenominationType) {
                $invalidValues[] = is_object($branchTypeDenominationItem) ? get_class($branchTypeDenominationItem) : sprintf('%s(%s)', gettype($branchTypeDenominationItem), var_export($branchTypeDenominationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Denomination property can only contain items of type \StructType\DenominationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Denomination value
     * @throws \InvalidArgumentException
     * @param \StructType\DenominationType[] $denomination
     * @return \StructType\BranchType
     */
    public function setDenomination(array $denomination = array())
    {
        // validation for constraint: array
        if ('' !== ($denominationArrayErrorMessage = self::validateDenominationForArrayConstraintsFromSetDenomination($denomination))) {
            throw new \InvalidArgumentException($denominationArrayErrorMessage, __LINE__);
        }
        $this->Denomination = $denomination;
        return $this;
    }
    /**
     * Add item to Denomination value
     * @throws \InvalidArgumentException
     * @param \StructType\DenominationType $item
     * @return \StructType\BranchType
     */
    public function addToDenomination(\StructType\DenominationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DenominationType) {
            throw new \InvalidArgumentException(sprintf('The Denomination property can only contain items of type \StructType\DenominationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Denomination[] = $item;
        return $this;
    }
}
