<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Read ServiceType
 * @subpackage Services
 */
class Read extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\RequestContextType $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(\StructType\RequestContextType $requestContext, $nameSpace = 'http://economie.fgov.be/kbopub/webservices/v1/messages', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ReadEnterprise
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEnterpriseRequestType $requestParameters
     * @return \StructType\ReadEnterpriseReplyType|bool
     */
    public function ReadEnterprise(\StructType\ReadEnterpriseRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterprise($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEnterpriseByPhoneme
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEnterpriseByPhonemeRequestType $requestParameters
     * @return \StructType\ReadEnterpriseByPhonemeReplyType|bool
     */
    public function ReadEnterpriseByPhoneme(\StructType\ReadEnterpriseByPhonemeRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseByPhoneme($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEstablishmentByEnterpriseNumber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEstablishmentByEnterpriseNumberRequestType $requestParameters
     * @return \StructType\ReadEstablishmentByEnterpriseNumberReplyType|bool
     */
    public function ReadEstablishmentByEnterpriseNumber(\StructType\ReadEstablishmentByEnterpriseNumberRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEstablishmentByEnterpriseNumber($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEstablishmentByEstablishmentNumber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEstablishmentByEstablishmentNumberRequestType $requestParameters
     * @return \StructType\ReadEstablishmentByEstablishmentNumberReplyType|bool
     */
    public function ReadEstablishmentByEstablishmentNumber(\StructType\ReadEstablishmentByEstablishmentNumberRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEstablishmentByEstablishmentNumber($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEnterpriseByPhysicalPersonNameExactMatch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEnterpriseByPhysicalPersonNameExactMatchRequestType $requestParameters
     * @return \StructType\ReadEnterpriseByPhysicalPersonNameExactMatchReplyType|bool
     */
    public function ReadEnterpriseByPhysicalPersonNameExactMatch(\StructType\ReadEnterpriseByPhysicalPersonNameExactMatchRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseByPhysicalPersonNameExactMatch($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEnterpriseLegalPersonByCompanyNameExactMatch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType $requestParameters
     * @return \StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchReplyType|bool
     */
    public function ReadEnterpriseLegalPersonByCompanyNameExactMatch(\StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseLegalPersonByCompanyNameExactMatch($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEstablishmentByNameExactMatch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEstablishmentByNameExactMatchRequestType $requestParameters
     * @return \StructType\ReadEstablishmentByNameExactMatchReplyType|bool
     */
    public function ReadEstablishmentByNameExactMatch(\StructType\ReadEstablishmentByNameExactMatchRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEstablishmentByNameExactMatch($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEstablishmentByPhoneme
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEstablishmentByPhonemeRequestType $requestParameters
     * @return \StructType\ReadEstablishmentByPhonemeReplyType|bool
     */
    public function ReadEstablishmentByPhoneme(\StructType\ReadEstablishmentByPhonemeRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEstablishmentByPhoneme($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEnterpriseOrEstablishmentByAddress
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEnterpriseOrEstablishmentByAddressRequestType $requestParameters
     * @return \StructType\ReadEnterpriseOrEstablishmentByAddressReplyType|bool
     */
    public function ReadEnterpriseOrEstablishmentByAddress(\StructType\ReadEnterpriseOrEstablishmentByAddressRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseOrEstablishmentByAddress($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadStreetName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadStreetNameRequestType $requestParameters
     * @return \StructType\ReadStreetNameReplyType|bool
     */
    public function ReadStreetName(\StructType\ReadStreetNameRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadStreetName($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEnterpriseOrEstablishmentByActivity
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEnterpriseOrEstablishmentByActivityRequestType $requestParameters
     * @return \StructType\ReadEnterpriseOrEstablishmentByActivityReplyType|bool
     */
    public function ReadEnterpriseOrEstablishmentByActivity(\StructType\ReadEnterpriseOrEstablishmentByActivityRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseOrEstablishmentByActivity($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEnterpriseByAuthorization
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEnterpriseByAuthorizationRequestType $requestParameters
     * @return \StructType\ReadEnterpriseByAuthorizationReplyType|bool
     */
    public function ReadEnterpriseByAuthorization(\StructType\ReadEnterpriseByAuthorizationRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseByAuthorization($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEstablishmentByAuthorization
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEstablishmentByAuthorizationRequestType $requestParameters
     * @return \StructType\ReadEstablishmentByAuthorizationReplyType|bool
     */
    public function ReadEstablishmentByAuthorization(\StructType\ReadEstablishmentByAuthorizationRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEstablishmentByAuthorization($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadCodeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadCodeListRequestType $requestParameters
     * @return \StructType\ReadCodeListReplyType|bool
     */
    public function ReadCodeList(\StructType\ReadCodeListRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadCodeList($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReadCodeListReplyType|\StructType\ReadEnterpriseByAuthorizationReplyType|\StructType\ReadEnterpriseByPhonemeReplyType|\StructType\ReadEnterpriseByPhysicalPersonNameExactMatchReplyType|\StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchReplyType|\StructType\ReadEnterpriseOrEstablishmentByActivityReplyType|\StructType\ReadEnterpriseOrEstablishmentByAddressReplyType|\StructType\ReadEnterpriseReplyType|\StructType\ReadEstablishmentByAuthorizationReplyType|\StructType\ReadEstablishmentByEnterpriseNumberReplyType|\StructType\ReadEstablishmentByEstablishmentNumberReplyType|\StructType\ReadEstablishmentByNameExactMatchReplyType|\StructType\ReadEstablishmentByPhonemeReplyType|\StructType\ReadStreetNameReplyType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
