<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadEstablishmentByPhonemeReplyType StructType
 * @subpackage Structs
 */
class ReadEstablishmentByPhonemeReplyType extends AbstractStructBase
{
    /**
     * The Establishment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: datamodel:Establishment
     * @var \StructType\EstablishmentType[]
     */
    public $Establishment;
    /**
     * Constructor method for ReadEstablishmentByPhonemeReplyType
     * @uses ReadEstablishmentByPhonemeReplyType::setEstablishment()
     * @param \StructType\EstablishmentType[] $establishment
     */
    public function __construct(array $establishment = array())
    {
        $this
            ->setEstablishment($establishment);
    }
    /**
     * Get Establishment value
     * @return \StructType\EstablishmentType[]|null
     */
    public function getEstablishment()
    {
        return $this->Establishment;
    }
    /**
     * This method is responsible for validating the values passed to the setEstablishment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstablishment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEstablishmentForArrayConstraintsFromSetEstablishment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readEstablishmentByPhonemeReplyTypeEstablishmentItem) {
            // validation for constraint: itemType
            if (!$readEstablishmentByPhonemeReplyTypeEstablishmentItem instanceof \StructType\EstablishmentType) {
                $invalidValues[] = is_object($readEstablishmentByPhonemeReplyTypeEstablishmentItem) ? get_class($readEstablishmentByPhonemeReplyTypeEstablishmentItem) : sprintf('%s(%s)', gettype($readEstablishmentByPhonemeReplyTypeEstablishmentItem), var_export($readEstablishmentByPhonemeReplyTypeEstablishmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Establishment property can only contain items of type \StructType\EstablishmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Establishment value
     * @throws \InvalidArgumentException
     * @param \StructType\EstablishmentType[] $establishment
     * @return \StructType\ReadEstablishmentByPhonemeReplyType
     */
    public function setEstablishment(array $establishment = array())
    {
        // validation for constraint: array
        if ('' !== ($establishmentArrayErrorMessage = self::validateEstablishmentForArrayConstraintsFromSetEstablishment($establishment))) {
            throw new \InvalidArgumentException($establishmentArrayErrorMessage, __LINE__);
        }
        $this->Establishment = $establishment;
        return $this;
    }
    /**
     * Add item to Establishment value
     * @throws \InvalidArgumentException
     * @param \StructType\EstablishmentType $item
     * @return \StructType\ReadEstablishmentByPhonemeReplyType
     */
    public function addToEstablishment(\StructType\EstablishmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EstablishmentType) {
            throw new \InvalidArgumentException(sprintf('The Establishment property can only contain items of type \StructType\EstablishmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Establishment[] = $item;
        return $this;
    }
}
