<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DenominationType StructType
 * @subpackage Structs
 */
class DenominationType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The ValidityPeriod
     * @var \StructType\PeriodType
     */
    public $ValidityPeriod;
    /**
     * Constructor method for DenominationType
     * @uses DenominationType::setCode()
     * @uses DenominationType::setDescription()
     * @uses DenominationType::setValidityPeriod()
     * @param string $code
     * @param \StructType\DescriptionType[] $description
     * @param \StructType\PeriodType $validityPeriod
     */
    public function __construct($code = null, array $description = array(), \StructType\PeriodType $validityPeriod = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setValidityPeriod($validityPeriod);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @uses \EnumType\DenominationCodeType::valueIsValid()
     * @uses \EnumType\DenominationCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\DenominationType
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DenominationCodeType::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DenominationCodeType', is_array($code) ? implode(', ', $code) : var_export($code, true), implode(', ', \EnumType\DenominationCodeType::getValidValues())), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $denominationTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$denominationTypeDescriptionItem instanceof \StructType\DescriptionType) {
                $invalidValues[] = is_object($denominationTypeDescriptionItem) ? get_class($denominationTypeDescriptionItem) : sprintf('%s(%s)', gettype($denominationTypeDescriptionItem), var_export($denominationTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType[] $description
     * @return \StructType\DenominationType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType $item
     * @return \StructType\DenominationType
     */
    public function addToDescription(\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \StructType\PeriodType|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \StructType\PeriodType $validityPeriod
     * @return \StructType\DenominationType
     */
    public function setValidityPeriod(\StructType\PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
}
