<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for Type EnumType
 * Meta information extracted from the WSDL
 * - documentation: Reference to the type of enterprise
 * @subpackage Enumerations
 */
class Type extends AbstractStructEnumBase
{
    /**
     * Constant for value 'ELP'
     * Meta information extracted from the WSDL
     * - documentation: Enterprise Legal Person
     * @return string 'ELP'
     */
    const VALUE_ELP = 'ELP';
    /**
     * Constant for value 'EPP'
     * Meta information extracted from the WSDL
     * - documentation: Enterprise Physical Person
     * @return string 'EPP'
     */
    const VALUE_EPP = 'EPP';
    /**
     * Return allowed values
     * @uses self::VALUE_ELP
     * @uses self::VALUE_EPP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ELP,
            self::VALUE_EPP,
        );
    }
}
