<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstablishmentType StructType
 * @subpackage Structs
 */
class EstablishmentType extends AbstractStructBase
{
    /**
     * The EstablishmentNumber
     * Meta information extracted from the WSDL
     * - base: xs:long
     * - pattern: [2-9][0-9]{9}
     * @var int
     */
    public $EstablishmentNumber;
    /**
     * The Status
     * @var \StructType\StatusType
     */
    public $Status;
    /**
     * The Period
     * @var \StructType\PeriodType
     */
    public $Period;
    /**
     * The EnterpriseNumber
     * Meta information extracted from the WSDL
     * - base: xs:long
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [01]?[0-9]{9}
     * @var int
     */
    public $EnterpriseNumber;
    /**
     * The EnterpriseStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StatusType
     */
    public $EnterpriseStatus;
    /**
     * The EnterpriseExOfficioStrikingOff
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExOfficioStrikingOffType[]
     */
    public $EnterpriseExOfficioStrikingOff;
    /**
     * The PrimaryDenomination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DescriptionType[]
     */
    public $PrimaryDenomination;
    /**
     * The Denomination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DenominationType[]
     */
    public $Denomination;
    /**
     * The Address
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * The ContactInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInformationType[]
     */
    public $ContactInformation;
    /**
     * The Authorization
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AuthorizationType[]
     */
    public $Authorization;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ActivityType[]
     */
    public $Activity;
    /**
     * Constructor method for EstablishmentType
     * @uses EstablishmentType::setEstablishmentNumber()
     * @uses EstablishmentType::setStatus()
     * @uses EstablishmentType::setPeriod()
     * @uses EstablishmentType::setEnterpriseNumber()
     * @uses EstablishmentType::setEnterpriseStatus()
     * @uses EstablishmentType::setEnterpriseExOfficioStrikingOff()
     * @uses EstablishmentType::setPrimaryDenomination()
     * @uses EstablishmentType::setDenomination()
     * @uses EstablishmentType::setAddress()
     * @uses EstablishmentType::setContactInformation()
     * @uses EstablishmentType::setAuthorization()
     * @uses EstablishmentType::setActivity()
     * @param int $establishmentNumber
     * @param \StructType\StatusType $status
     * @param \StructType\PeriodType $period
     * @param int $enterpriseNumber
     * @param \StructType\StatusType $enterpriseStatus
     * @param \StructType\ExOfficioStrikingOffType[] $enterpriseExOfficioStrikingOff
     * @param \StructType\DescriptionType[] $primaryDenomination
     * @param \StructType\DenominationType[] $denomination
     * @param \StructType\AddressType $address
     * @param \StructType\ContactInformationType[] $contactInformation
     * @param \StructType\AuthorizationType[] $authorization
     * @param \StructType\ActivityType[] $activity
     */
    public function __construct($establishmentNumber = null, \StructType\StatusType $status = null, \StructType\PeriodType $period = null, $enterpriseNumber = null, \StructType\StatusType $enterpriseStatus = null, array $enterpriseExOfficioStrikingOff = array(), array $primaryDenomination = array(), array $denomination = array(), \StructType\AddressType $address = null, array $contactInformation = array(), array $authorization = array(), array $activity = array())
    {
        $this
            ->setEstablishmentNumber($establishmentNumber)
            ->setStatus($status)
            ->setPeriod($period)
            ->setEnterpriseNumber($enterpriseNumber)
            ->setEnterpriseStatus($enterpriseStatus)
            ->setEnterpriseExOfficioStrikingOff($enterpriseExOfficioStrikingOff)
            ->setPrimaryDenomination($primaryDenomination)
            ->setDenomination($denomination)
            ->setAddress($address)
            ->setContactInformation($contactInformation)
            ->setAuthorization($authorization)
            ->setActivity($activity);
    }
    /**
     * Get EstablishmentNumber value
     * @return int|null
     */
    public function getEstablishmentNumber()
    {
        return $this->EstablishmentNumber;
    }
    /**
     * Set EstablishmentNumber value
     * @param int $establishmentNumber
     * @return \StructType\EstablishmentType
     */
    public function setEstablishmentNumber($establishmentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($establishmentNumber) && !(is_int($establishmentNumber) || ctype_digit($establishmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishmentNumber, true), gettype($establishmentNumber)), __LINE__);
        }
        // validation for constraint: pattern([2-9][0-9]{9})
        if (!is_null($establishmentNumber) && !preg_match('/[2-9][0-9]{9}/', $establishmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [2-9][0-9]{9}', var_export($establishmentNumber, true)), __LINE__);
        }
        $this->EstablishmentNumber = $establishmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\StatusType|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\StatusType $status
     * @return \StructType\EstablishmentType
     */
    public function setStatus(\StructType\StatusType $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Period value
     * @return \StructType\PeriodType|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \StructType\PeriodType $period
     * @return \StructType\EstablishmentType
     */
    public function setPeriod(\StructType\PeriodType $period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Get EnterpriseNumber value
     * @return int|null
     */
    public function getEnterpriseNumber()
    {
        return $this->EnterpriseNumber;
    }
    /**
     * Set EnterpriseNumber value
     * @param int $enterpriseNumber
     * @return \StructType\EstablishmentType
     */
    public function setEnterpriseNumber($enterpriseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($enterpriseNumber) && !(is_int($enterpriseNumber) || ctype_digit($enterpriseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enterpriseNumber, true), gettype($enterpriseNumber)), __LINE__);
        }
        // validation for constraint: pattern([01]?[0-9]{9})
        if (!is_null($enterpriseNumber) && !preg_match('/[01]?[0-9]{9}/', $enterpriseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [01]?[0-9]{9}', var_export($enterpriseNumber, true)), __LINE__);
        }
        $this->EnterpriseNumber = $enterpriseNumber;
        return $this;
    }
    /**
     * Get EnterpriseStatus value
     * @return \StructType\StatusType|null
     */
    public function getEnterpriseStatus()
    {
        return $this->EnterpriseStatus;
    }
    /**
     * Set EnterpriseStatus value
     * @param \StructType\StatusType $enterpriseStatus
     * @return \StructType\EstablishmentType
     */
    public function setEnterpriseStatus(\StructType\StatusType $enterpriseStatus = null)
    {
        $this->EnterpriseStatus = $enterpriseStatus;
        return $this;
    }
    /**
     * Get EnterpriseExOfficioStrikingOff value
     * @return \StructType\ExOfficioStrikingOffType[]|null
     */
    public function getEnterpriseExOfficioStrikingOff()
    {
        return $this->EnterpriseExOfficioStrikingOff;
    }
    /**
     * This method is responsible for validating the values passed to the setEnterpriseExOfficioStrikingOff method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnterpriseExOfficioStrikingOff method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEnterpriseExOfficioStrikingOffForArrayConstraintsFromSetEnterpriseExOfficioStrikingOff(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypeEnterpriseExOfficioStrikingOffItem) {
            // validation for constraint: itemType
            if (!$establishmentTypeEnterpriseExOfficioStrikingOffItem instanceof \StructType\ExOfficioStrikingOffType) {
                $invalidValues[] = is_object($establishmentTypeEnterpriseExOfficioStrikingOffItem) ? get_class($establishmentTypeEnterpriseExOfficioStrikingOffItem) : sprintf('%s(%s)', gettype($establishmentTypeEnterpriseExOfficioStrikingOffItem), var_export($establishmentTypeEnterpriseExOfficioStrikingOffItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EnterpriseExOfficioStrikingOff property can only contain items of type \StructType\ExOfficioStrikingOffType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EnterpriseExOfficioStrikingOff value
     * @throws \InvalidArgumentException
     * @param \StructType\ExOfficioStrikingOffType[] $enterpriseExOfficioStrikingOff
     * @return \StructType\EstablishmentType
     */
    public function setEnterpriseExOfficioStrikingOff(array $enterpriseExOfficioStrikingOff = array())
    {
        // validation for constraint: array
        if ('' !== ($enterpriseExOfficioStrikingOffArrayErrorMessage = self::validateEnterpriseExOfficioStrikingOffForArrayConstraintsFromSetEnterpriseExOfficioStrikingOff($enterpriseExOfficioStrikingOff))) {
            throw new \InvalidArgumentException($enterpriseExOfficioStrikingOffArrayErrorMessage, __LINE__);
        }
        $this->EnterpriseExOfficioStrikingOff = $enterpriseExOfficioStrikingOff;
        return $this;
    }
    /**
     * Add item to EnterpriseExOfficioStrikingOff value
     * @throws \InvalidArgumentException
     * @param \StructType\ExOfficioStrikingOffType $item
     * @return \StructType\EstablishmentType
     */
    public function addToEnterpriseExOfficioStrikingOff(\StructType\ExOfficioStrikingOffType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExOfficioStrikingOffType) {
            throw new \InvalidArgumentException(sprintf('The EnterpriseExOfficioStrikingOff property can only contain items of type \StructType\ExOfficioStrikingOffType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EnterpriseExOfficioStrikingOff[] = $item;
        return $this;
    }
    /**
     * Get PrimaryDenomination value
     * @return \StructType\DescriptionType[]|null
     */
    public function getPrimaryDenomination()
    {
        return $this->PrimaryDenomination;
    }
    /**
     * This method is responsible for validating the values passed to the setPrimaryDenomination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrimaryDenomination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrimaryDenominationForArrayConstraintsFromSetPrimaryDenomination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypePrimaryDenominationItem) {
            // validation for constraint: itemType
            if (!$establishmentTypePrimaryDenominationItem instanceof \StructType\DescriptionType) {
                $invalidValues[] = is_object($establishmentTypePrimaryDenominationItem) ? get_class($establishmentTypePrimaryDenominationItem) : sprintf('%s(%s)', gettype($establishmentTypePrimaryDenominationItem), var_export($establishmentTypePrimaryDenominationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PrimaryDenomination property can only contain items of type \StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PrimaryDenomination value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType[] $primaryDenomination
     * @return \StructType\EstablishmentType
     */
    public function setPrimaryDenomination(array $primaryDenomination = array())
    {
        // validation for constraint: array
        if ('' !== ($primaryDenominationArrayErrorMessage = self::validatePrimaryDenominationForArrayConstraintsFromSetPrimaryDenomination($primaryDenomination))) {
            throw new \InvalidArgumentException($primaryDenominationArrayErrorMessage, __LINE__);
        }
        $this->PrimaryDenomination = $primaryDenomination;
        return $this;
    }
    /**
     * Add item to PrimaryDenomination value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType $item
     * @return \StructType\EstablishmentType
     */
    public function addToPrimaryDenomination(\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The PrimaryDenomination property can only contain items of type \StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PrimaryDenomination[] = $item;
        return $this;
    }
    /**
     * Get Denomination value
     * @return \StructType\DenominationType[]|null
     */
    public function getDenomination()
    {
        return $this->Denomination;
    }
    /**
     * This method is responsible for validating the values passed to the setDenomination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDenomination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDenominationForArrayConstraintsFromSetDenomination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypeDenominationItem) {
            // validation for constraint: itemType
            if (!$establishmentTypeDenominationItem instanceof \StructType\DenominationType) {
                $invalidValues[] = is_object($establishmentTypeDenominationItem) ? get_class($establishmentTypeDenominationItem) : sprintf('%s(%s)', gettype($establishmentTypeDenominationItem), var_export($establishmentTypeDenominationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Denomination property can only contain items of type \StructType\DenominationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Denomination value
     * @throws \InvalidArgumentException
     * @param \StructType\DenominationType[] $denomination
     * @return \StructType\EstablishmentType
     */
    public function setDenomination(array $denomination = array())
    {
        // validation for constraint: array
        if ('' !== ($denominationArrayErrorMessage = self::validateDenominationForArrayConstraintsFromSetDenomination($denomination))) {
            throw new \InvalidArgumentException($denominationArrayErrorMessage, __LINE__);
        }
        $this->Denomination = $denomination;
        return $this;
    }
    /**
     * Add item to Denomination value
     * @throws \InvalidArgumentException
     * @param \StructType\DenominationType $item
     * @return \StructType\EstablishmentType
     */
    public function addToDenomination(\StructType\DenominationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DenominationType) {
            throw new \InvalidArgumentException(sprintf('The Denomination property can only contain items of type \StructType\DenominationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Denomination[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\EstablishmentType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactInformation value
     * @return \StructType\ContactInformationType[]|null
     */
    public function getContactInformation()
    {
        return $this->ContactInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInformationForArrayConstraintsFromSetContactInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypeContactInformationItem) {
            // validation for constraint: itemType
            if (!$establishmentTypeContactInformationItem instanceof \StructType\ContactInformationType) {
                $invalidValues[] = is_object($establishmentTypeContactInformationItem) ? get_class($establishmentTypeContactInformationItem) : sprintf('%s(%s)', gettype($establishmentTypeContactInformationItem), var_export($establishmentTypeContactInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInformation property can only contain items of type \StructType\ContactInformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInformationType[] $contactInformation
     * @return \StructType\EstablishmentType
     */
    public function setContactInformation(array $contactInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInformationArrayErrorMessage = self::validateContactInformationForArrayConstraintsFromSetContactInformation($contactInformation))) {
            throw new \InvalidArgumentException($contactInformationArrayErrorMessage, __LINE__);
        }
        $this->ContactInformation = $contactInformation;
        return $this;
    }
    /**
     * Add item to ContactInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInformationType $item
     * @return \StructType\EstablishmentType
     */
    public function addToContactInformation(\StructType\ContactInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInformationType) {
            throw new \InvalidArgumentException(sprintf('The ContactInformation property can only contain items of type \StructType\ContactInformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInformation[] = $item;
        return $this;
    }
    /**
     * Get Authorization value
     * @return \StructType\AuthorizationType[]|null
     */
    public function getAuthorization()
    {
        return $this->Authorization;
    }
    /**
     * This method is responsible for validating the values passed to the setAuthorization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorization method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuthorizationForArrayConstraintsFromSetAuthorization(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypeAuthorizationItem) {
            // validation for constraint: itemType
            if (!$establishmentTypeAuthorizationItem instanceof \StructType\AuthorizationType) {
                $invalidValues[] = is_object($establishmentTypeAuthorizationItem) ? get_class($establishmentTypeAuthorizationItem) : sprintf('%s(%s)', gettype($establishmentTypeAuthorizationItem), var_export($establishmentTypeAuthorizationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Authorization property can only contain items of type \StructType\AuthorizationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Authorization value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizationType[] $authorization
     * @return \StructType\EstablishmentType
     */
    public function setAuthorization(array $authorization = array())
    {
        // validation for constraint: array
        if ('' !== ($authorizationArrayErrorMessage = self::validateAuthorizationForArrayConstraintsFromSetAuthorization($authorization))) {
            throw new \InvalidArgumentException($authorizationArrayErrorMessage, __LINE__);
        }
        $this->Authorization = $authorization;
        return $this;
    }
    /**
     * Add item to Authorization value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizationType $item
     * @return \StructType\EstablishmentType
     */
    public function addToAuthorization(\StructType\AuthorizationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AuthorizationType) {
            throw new \InvalidArgumentException(sprintf('The Authorization property can only contain items of type \StructType\AuthorizationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Authorization[] = $item;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\ActivityType[]|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * This method is responsible for validating the values passed to the setActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityForArrayConstraintsFromSetActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypeActivityItem) {
            // validation for constraint: itemType
            if (!$establishmentTypeActivityItem instanceof \StructType\ActivityType) {
                $invalidValues[] = is_object($establishmentTypeActivityItem) ? get_class($establishmentTypeActivityItem) : sprintf('%s(%s)', gettype($establishmentTypeActivityItem), var_export($establishmentTypeActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Activity property can only contain items of type \StructType\ActivityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Activity value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityType[] $activity
     * @return \StructType\EstablishmentType
     */
    public function setActivity(array $activity = array())
    {
        // validation for constraint: array
        if ('' !== ($activityArrayErrorMessage = self::validateActivityForArrayConstraintsFromSetActivity($activity))) {
            throw new \InvalidArgumentException($activityArrayErrorMessage, __LINE__);
        }
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Add item to Activity value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityType $item
     * @return \StructType\EstablishmentType
     */
    public function addToActivity(\StructType\ActivityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityType) {
            throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of type \StructType\ActivityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Activity[] = $item;
        return $this;
    }
}
