<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityFilterType StructType
 * @subpackage Structs
 */
class ActivityFilterType extends AbstractStructBase
{
    /**
     * The ActivityCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 7
     * - maxOccurs: 10
     * - minLength: 3
     * - pattern: \d{3,7}
     * @var string[]
     */
    public $ActivityCode;
    /**
     * Constructor method for ActivityFilterType
     * @uses ActivityFilterType::setActivityCode()
     * @param string[] $activityCode
     */
    public function __construct(array $activityCode = array())
    {
        $this
            ->setActivityCode($activityCode);
    }
    /**
     * Get ActivityCode value
     * @return string[]|null
     */
    public function getActivityCode()
    {
        return $this->ActivityCode;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityCodeForArrayConstraintsFromSetActivityCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityFilterTypeActivityCodeItem) {
            // validation for constraint: itemType
            if (!is_string($activityFilterTypeActivityCodeItem)) {
                $invalidValues[] = is_object($activityFilterTypeActivityCodeItem) ? get_class($activityFilterTypeActivityCodeItem) : sprintf('%s(%s)', gettype($activityFilterTypeActivityCodeItem), var_export($activityFilterTypeActivityCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setActivityCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityCode method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityCodeForMaxLengthConstraintFromSetActivityCode($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityFilterTypeActivityCodeItem) {
            // validation for constraint: maxLength(7)
            if (mb_strlen($activityFilterTypeActivityCodeItem) > 7) {
                $invalidValues[] = var_export($activityFilterTypeActivityCodeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 7', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setActivityCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityCode method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityCodeForMinLengthConstraintFromSetActivityCode($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityFilterTypeActivityCodeItem) {
            // validation for constraint: minLength(3)
            if (mb_strlen($activityFilterTypeActivityCodeItem) < 3) {
                $invalidValues[] = var_export($activityFilterTypeActivityCodeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 3', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityCode value
     * @throws \InvalidArgumentException
     * @param string[] $activityCode
     * @return \StructType\ActivityFilterType
     */
    public function setActivityCode(array $activityCode = array())
    {
        // validation for constraint: array
        if ('' !== ($activityCodeArrayErrorMessage = self::validateActivityCodeForArrayConstraintsFromSetActivityCode($activityCode))) {
            throw new \InvalidArgumentException($activityCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(7)
        if ('' !== ($activityCodeMaxLengthErrorMessage = self::validateActivityCodeForMaxLengthConstraintFromSetActivityCode($activityCode))) {
            throw new \InvalidArgumentException($activityCodeMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($activityCode) && count($activityCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($activityCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if ('' !== ($activityCodeMinLengthErrorMessage = self::validateActivityCodeForMinLengthConstraintFromSetActivityCode($activityCode))) {
            throw new \InvalidArgumentException($activityCodeMinLengthErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\d{3,7})
        if (!is_null($activityCode) && !preg_match('/\\d{3,7}/', $activityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{3,7}', var_export($activityCode, true)), __LINE__);
        }
        $this->ActivityCode = $activityCode;
        return $this;
    }
    /**
     * Add item to ActivityCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ActivityFilterType
     */
    public function addToActivityCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ActivityCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (mb_strlen($item) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->ActivityCode) && count($this->ActivityCode) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->ActivityCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (mb_strlen($item) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: pattern(\d{3,7})
        if (!preg_match('/\\d{3,7}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{3,7}', var_export($item, true)), __LINE__);
        }
        $this->ActivityCode[] = $item;
        return $this;
    }
}
