<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationFilterType StructType
 * @subpackage Structs
 */
class LocationFilterType extends AbstractStructBase
{
    /**
     * The MunicipalityLocationFilter
     * Meta information extracted from the WSDL
     * - choice: MunicipalityLocationFilter | NeighboringMunicipalityLocationFilter | ZipcodeLocationFilter
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\MunicipalityLocationFilterType
     */
    public $MunicipalityLocationFilter;
    /**
     * The NeighboringMunicipalityLocationFilter
     * Meta information extracted from the WSDL
     * - choice: MunicipalityLocationFilter | NeighboringMunicipalityLocationFilter | ZipcodeLocationFilter
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\NeighboringMunicipalityLocationFilterType
     */
    public $NeighboringMunicipalityLocationFilter;
    /**
     * The ZipcodeLocationFilter
     * Meta information extracted from the WSDL
     * - choice: MunicipalityLocationFilter | NeighboringMunicipalityLocationFilter | ZipcodeLocationFilter
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ZipcodeLocationFilterType
     */
    public $ZipcodeLocationFilter;
    /**
     * Constructor method for LocationFilterType
     * @uses LocationFilterType::setMunicipalityLocationFilter()
     * @uses LocationFilterType::setNeighboringMunicipalityLocationFilter()
     * @uses LocationFilterType::setZipcodeLocationFilter()
     * @param \StructType\MunicipalityLocationFilterType $municipalityLocationFilter
     * @param \StructType\NeighboringMunicipalityLocationFilterType $neighboringMunicipalityLocationFilter
     * @param \StructType\ZipcodeLocationFilterType $zipcodeLocationFilter
     */
    public function __construct(\StructType\MunicipalityLocationFilterType $municipalityLocationFilter = null, \StructType\NeighboringMunicipalityLocationFilterType $neighboringMunicipalityLocationFilter = null, \StructType\ZipcodeLocationFilterType $zipcodeLocationFilter = null)
    {
        $this
            ->setMunicipalityLocationFilter($municipalityLocationFilter)
            ->setNeighboringMunicipalityLocationFilter($neighboringMunicipalityLocationFilter)
            ->setZipcodeLocationFilter($zipcodeLocationFilter);
    }
    /**
     * Get MunicipalityLocationFilter value
     * @return \StructType\MunicipalityLocationFilterType|null
     */
    public function getMunicipalityLocationFilter()
    {
        return isset($this->MunicipalityLocationFilter) ? $this->MunicipalityLocationFilter : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMunicipalityLocationFilter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMunicipalityLocationFilter method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMunicipalityLocationFilterForChoiceConstraintsFromSetMunicipalityLocationFilter($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NeighboringMunicipalityLocationFilter',
            'ZipcodeLocationFilter',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MunicipalityLocationFilter can\'t be set as the property %s is already set. Only one property must be set among these properties: MunicipalityLocationFilter, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MunicipalityLocationFilter value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MunicipalityLocationFilterType $municipalityLocationFilter
     * @return \StructType\LocationFilterType
     */
    public function setMunicipalityLocationFilter(\StructType\MunicipalityLocationFilterType $municipalityLocationFilter = null)
    {
        // validation for constraint: choice(MunicipalityLocationFilter, NeighboringMunicipalityLocationFilter, ZipcodeLocationFilter)
        if ('' !== ($municipalityLocationFilterChoiceErrorMessage = self::validateMunicipalityLocationFilterForChoiceConstraintsFromSetMunicipalityLocationFilter($municipalityLocationFilter))) {
            throw new \InvalidArgumentException($municipalityLocationFilterChoiceErrorMessage, __LINE__);
        }
        if (is_null($municipalityLocationFilter) || (is_array($municipalityLocationFilter) && empty($municipalityLocationFilter))) {
            unset($this->MunicipalityLocationFilter);
        } else {
            $this->MunicipalityLocationFilter = $municipalityLocationFilter;
        }
        return $this;
    }
    /**
     * Get NeighboringMunicipalityLocationFilter value
     * @return \StructType\NeighboringMunicipalityLocationFilterType|null
     */
    public function getNeighboringMunicipalityLocationFilter()
    {
        return isset($this->NeighboringMunicipalityLocationFilter) ? $this->NeighboringMunicipalityLocationFilter : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNeighboringMunicipalityLocationFilter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNeighboringMunicipalityLocationFilter method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNeighboringMunicipalityLocationFilterForChoiceConstraintsFromSetNeighboringMunicipalityLocationFilter($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'MunicipalityLocationFilter',
            'ZipcodeLocationFilter',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NeighboringMunicipalityLocationFilter can\'t be set as the property %s is already set. Only one property must be set among these properties: NeighboringMunicipalityLocationFilter, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NeighboringMunicipalityLocationFilter value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NeighboringMunicipalityLocationFilterType $neighboringMunicipalityLocationFilter
     * @return \StructType\LocationFilterType
     */
    public function setNeighboringMunicipalityLocationFilter(\StructType\NeighboringMunicipalityLocationFilterType $neighboringMunicipalityLocationFilter = null)
    {
        // validation for constraint: choice(MunicipalityLocationFilter, NeighboringMunicipalityLocationFilter, ZipcodeLocationFilter)
        if ('' !== ($neighboringMunicipalityLocationFilterChoiceErrorMessage = self::validateNeighboringMunicipalityLocationFilterForChoiceConstraintsFromSetNeighboringMunicipalityLocationFilter($neighboringMunicipalityLocationFilter))) {
            throw new \InvalidArgumentException($neighboringMunicipalityLocationFilterChoiceErrorMessage, __LINE__);
        }
        if (is_null($neighboringMunicipalityLocationFilter) || (is_array($neighboringMunicipalityLocationFilter) && empty($neighboringMunicipalityLocationFilter))) {
            unset($this->NeighboringMunicipalityLocationFilter);
        } else {
            $this->NeighboringMunicipalityLocationFilter = $neighboringMunicipalityLocationFilter;
        }
        return $this;
    }
    /**
     * Get ZipcodeLocationFilter value
     * @return \StructType\ZipcodeLocationFilterType|null
     */
    public function getZipcodeLocationFilter()
    {
        return isset($this->ZipcodeLocationFilter) ? $this->ZipcodeLocationFilter : null;
    }
    /**
     * This method is responsible for validating the value passed to the setZipcodeLocationFilter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZipcodeLocationFilter method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateZipcodeLocationFilterForChoiceConstraintsFromSetZipcodeLocationFilter($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'MunicipalityLocationFilter',
            'NeighboringMunicipalityLocationFilter',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ZipcodeLocationFilter can\'t be set as the property %s is already set. Only one property must be set among these properties: ZipcodeLocationFilter, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ZipcodeLocationFilter value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ZipcodeLocationFilterType $zipcodeLocationFilter
     * @return \StructType\LocationFilterType
     */
    public function setZipcodeLocationFilter(\StructType\ZipcodeLocationFilterType $zipcodeLocationFilter = null)
    {
        // validation for constraint: choice(MunicipalityLocationFilter, NeighboringMunicipalityLocationFilter, ZipcodeLocationFilter)
        if ('' !== ($zipcodeLocationFilterChoiceErrorMessage = self::validateZipcodeLocationFilterForChoiceConstraintsFromSetZipcodeLocationFilter($zipcodeLocationFilter))) {
            throw new \InvalidArgumentException($zipcodeLocationFilterChoiceErrorMessage, __LINE__);
        }
        if (is_null($zipcodeLocationFilter) || (is_array($zipcodeLocationFilter) && empty($zipcodeLocationFilter))) {
            unset($this->ZipcodeLocationFilter);
        } else {
            $this->ZipcodeLocationFilter = $zipcodeLocationFilter;
        }
        return $this;
    }
}
