<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://kbopub-acc.economie.fgov.be/kbopubws110000/services/wsKBOPub?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://kbopub-acc.economie.fgov.be/kbopubws110000/services/wsKBOPub?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Read ServiceType
 */
$read = new \ServiceType\Read($options);
$read->setSoapHeaderRequestContext($RequestContext);
/**
 * Sample call for ReadEnterprise operation/method
 */
if ($read->ReadEnterprise(new \StructType\ReadEnterpriseRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseByPhoneme operation/method
 */
if ($read->ReadEnterpriseByPhoneme(new \StructType\ReadEnterpriseByPhonemeRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEstablishmentByEnterpriseNumber operation/method
 */
if ($read->ReadEstablishmentByEnterpriseNumber(new \StructType\ReadEstablishmentByEnterpriseNumberRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEstablishmentByEstablishmentNumber operation/method
 */
if ($read->ReadEstablishmentByEstablishmentNumber(new \StructType\ReadEstablishmentByEstablishmentNumberRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseByPhysicalPersonNameExactMatch operation/method
 */
if ($read->ReadEnterpriseByPhysicalPersonNameExactMatch(new \StructType\ReadEnterpriseByPhysicalPersonNameExactMatchRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseLegalPersonByCompanyNameExactMatch
 * operation/method
 */
if ($read->ReadEnterpriseLegalPersonByCompanyNameExactMatch(new \StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEstablishmentByNameExactMatch operation/method
 */
if ($read->ReadEstablishmentByNameExactMatch(new \StructType\ReadEstablishmentByNameExactMatchRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEstablishmentByPhoneme operation/method
 */
if ($read->ReadEstablishmentByPhoneme(new \StructType\ReadEstablishmentByPhonemeRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseOrEstablishmentByAddress operation/method
 */
if ($read->ReadEnterpriseOrEstablishmentByAddress(new \StructType\ReadEnterpriseOrEstablishmentByAddressRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadStreetName operation/method
 */
if ($read->ReadStreetName(new \StructType\ReadStreetNameRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseOrEstablishmentByActivity operation/method
 */
if ($read->ReadEnterpriseOrEstablishmentByActivity(new \StructType\ReadEnterpriseOrEstablishmentByActivityRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseByAuthorization operation/method
 */
if ($read->ReadEnterpriseByAuthorization(new \StructType\ReadEnterpriseByAuthorizationRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEstablishmentByAuthorization operation/method
 */
if ($read->ReadEstablishmentByAuthorization(new \StructType\ReadEstablishmentByAuthorizationRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadCodeList operation/method
 */
if ($read->ReadCodeList(new \StructType\ReadCodeListRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
