<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodeListItemType StructType
 * @subpackage Structs
 */
class CodeListItemType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The KeyValuePair
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValuePairType[]
     */
    public $KeyValuePair;
    /**
     * Constructor method for CodeListItemType
     * @uses CodeListItemType::setCode()
     * @uses CodeListItemType::setDescription()
     * @uses CodeListItemType::setKeyValuePair()
     * @param string $code
     * @param \StructType\DescriptionType[] $description
     * @param \StructType\KeyValuePairType[] $keyValuePair
     */
    public function __construct($code = null, array $description = array(), array $keyValuePair = array())
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setKeyValuePair($keyValuePair);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\CodeListItemType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $codeListItemTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$codeListItemTypeDescriptionItem instanceof \StructType\DescriptionType) {
                $invalidValues[] = is_object($codeListItemTypeDescriptionItem) ? get_class($codeListItemTypeDescriptionItem) : sprintf('%s(%s)', gettype($codeListItemTypeDescriptionItem), var_export($codeListItemTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType[] $description
     * @return \StructType\CodeListItemType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType $item
     * @return \StructType\CodeListItemType
     */
    public function addToDescription(\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get KeyValuePair value
     * @return \StructType\KeyValuePairType[]|null
     */
    public function getKeyValuePair()
    {
        return $this->KeyValuePair;
    }
    /**
     * This method is responsible for validating the values passed to the setKeyValuePair method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyValuePair method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeyValuePairForArrayConstraintsFromSetKeyValuePair(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $codeListItemTypeKeyValuePairItem) {
            // validation for constraint: itemType
            if (!$codeListItemTypeKeyValuePairItem instanceof \StructType\KeyValuePairType) {
                $invalidValues[] = is_object($codeListItemTypeKeyValuePairItem) ? get_class($codeListItemTypeKeyValuePairItem) : sprintf('%s(%s)', gettype($codeListItemTypeKeyValuePairItem), var_export($codeListItemTypeKeyValuePairItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KeyValuePair property can only contain items of type \StructType\KeyValuePairType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KeyValuePair value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePairType[] $keyValuePair
     * @return \StructType\CodeListItemType
     */
    public function setKeyValuePair(array $keyValuePair = array())
    {
        // validation for constraint: array
        if ('' !== ($keyValuePairArrayErrorMessage = self::validateKeyValuePairForArrayConstraintsFromSetKeyValuePair($keyValuePair))) {
            throw new \InvalidArgumentException($keyValuePairArrayErrorMessage, __LINE__);
        }
        $this->KeyValuePair = $keyValuePair;
        return $this;
    }
    /**
     * Add item to KeyValuePair value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePairType $item
     * @return \StructType\CodeListItemType
     */
    public function addToKeyValuePair(\StructType\KeyValuePairType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValuePairType) {
            throw new \InvalidArgumentException(sprintf('The KeyValuePair property can only contain items of type \StructType\KeyValuePairType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KeyValuePair[] = $item;
        return $this;
    }
}
