<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JuridicalFormType StructType
 * @subpackage Structs
 */
class JuridicalFormType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PeriodType
     */
    public $ValidityPeriod;
    /**
     * The JuridicalFormCAC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JuridicalFormCACType
     */
    public $JuridicalFormCAC;
    /**
     * Constructor method for JuridicalFormType
     * @uses JuridicalFormType::setCode()
     * @uses JuridicalFormType::setDescription()
     * @uses JuridicalFormType::setValidityPeriod()
     * @uses JuridicalFormType::setJuridicalFormCAC()
     * @param string $code
     * @param \StructType\DescriptionType[] $description
     * @param \StructType\PeriodType $validityPeriod
     * @param \StructType\JuridicalFormCACType $juridicalFormCAC
     */
    public function __construct($code = null, array $description = array(), \StructType\PeriodType $validityPeriod = null, \StructType\JuridicalFormCACType $juridicalFormCAC = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setValidityPeriod($validityPeriod)
            ->setJuridicalFormCAC($juridicalFormCAC);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JuridicalFormType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $juridicalFormTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$juridicalFormTypeDescriptionItem instanceof \StructType\DescriptionType) {
                $invalidValues[] = is_object($juridicalFormTypeDescriptionItem) ? get_class($juridicalFormTypeDescriptionItem) : sprintf('%s(%s)', gettype($juridicalFormTypeDescriptionItem), var_export($juridicalFormTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType[] $description
     * @return \StructType\JuridicalFormType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\DescriptionType $item
     * @return \StructType\JuridicalFormType
     */
    public function addToDescription(\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \StructType\PeriodType|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \StructType\PeriodType $validityPeriod
     * @return \StructType\JuridicalFormType
     */
    public function setValidityPeriod(\StructType\PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get JuridicalFormCAC value
     * @return \StructType\JuridicalFormCACType|null
     */
    public function getJuridicalFormCAC()
    {
        return $this->JuridicalFormCAC;
    }
    /**
     * Set JuridicalFormCAC value
     * @param \StructType\JuridicalFormCACType $juridicalFormCAC
     * @return \StructType\JuridicalFormType
     */
    public function setJuridicalFormCAC(\StructType\JuridicalFormCACType $juridicalFormCAC = null)
    {
        $this->JuridicalFormCAC = $juridicalFormCAC;
        return $this;
    }
}
