<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MunicipalityLocationFilterType StructType
 * @subpackage Structs
 */
class MunicipalityLocationFilterType extends AbstractStructBase
{
    /**
     * The MunicipalityCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 5
     * - maxOccurs: 4
     * - pattern: \d{5}
     * @var string[]
     */
    public $MunicipalityCode;
    /**
     * Constructor method for MunicipalityLocationFilterType
     * @uses MunicipalityLocationFilterType::setMunicipalityCode()
     * @param string[] $municipalityCode
     */
    public function __construct(array $municipalityCode = array())
    {
        $this
            ->setMunicipalityCode($municipalityCode);
    }
    /**
     * Get MunicipalityCode value
     * @return string[]|null
     */
    public function getMunicipalityCode()
    {
        return $this->MunicipalityCode;
    }
    /**
     * This method is responsible for validating the values passed to the setMunicipalityCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMunicipalityCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMunicipalityCodeForArrayConstraintsFromSetMunicipalityCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $municipalityLocationFilterTypeMunicipalityCodeItem) {
            // validation for constraint: itemType
            if (!is_string($municipalityLocationFilterTypeMunicipalityCodeItem)) {
                $invalidValues[] = is_object($municipalityLocationFilterTypeMunicipalityCodeItem) ? get_class($municipalityLocationFilterTypeMunicipalityCodeItem) : sprintf('%s(%s)', gettype($municipalityLocationFilterTypeMunicipalityCodeItem), var_export($municipalityLocationFilterTypeMunicipalityCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MunicipalityCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMunicipalityCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMunicipalityCode method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMunicipalityCodeForLengthConstraintFromSetMunicipalityCode($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $municipalityLocationFilterTypeMunicipalityCodeItem) {
            // validation for constraint: length(5)
            if (mb_strlen($municipalityLocationFilterTypeMunicipalityCodeItem) !== 5) {
                $invalidValues[] = var_export($municipalityLocationFilterTypeMunicipalityCodeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 5', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MunicipalityCode value
     * @throws \InvalidArgumentException
     * @param string[] $municipalityCode
     * @return \StructType\MunicipalityLocationFilterType
     */
    public function setMunicipalityCode(array $municipalityCode = array())
    {
        // validation for constraint: array
        if ('' !== ($municipalityCodeArrayErrorMessage = self::validateMunicipalityCodeForArrayConstraintsFromSetMunicipalityCode($municipalityCode))) {
            throw new \InvalidArgumentException($municipalityCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(5)
        if ('' !== ($municipalityCodeLengthErrorMessage = self::validateMunicipalityCodeForLengthConstraintFromSetMunicipalityCode($municipalityCode))) {
            throw new \InvalidArgumentException($municipalityCodeLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($municipalityCode) && count($municipalityCode) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($municipalityCode)), __LINE__);
        }
        // validation for constraint: pattern(\d{5})
        if (!is_null($municipalityCode) && !preg_match('/\\d{5}/', $municipalityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{5}', var_export($municipalityCode, true)), __LINE__);
        }
        $this->MunicipalityCode = $municipalityCode;
        return $this;
    }
    /**
     * Add item to MunicipalityCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MunicipalityLocationFilterType
     */
    public function addToMunicipalityCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MunicipalityCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(5)
        if (mb_strlen($item) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->MunicipalityCode) && count($this->MunicipalityCode) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->MunicipalityCode)), __LINE__);
        }
        // validation for constraint: pattern(\d{5})
        if (!preg_match('/\\d{5}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{5}', var_export($item, true)), __LINE__);
        }
        $this->MunicipalityCode[] = $item;
        return $this;
    }
}
