<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadEnterpriseOrEstablishmentByActivityRequestType
 * StructType
 * @subpackage Structs
 */
class ReadEnterpriseOrEstablishmentByActivityRequestType extends AbstractStructBase
{
    /**
     * The ActivityFilter
     * @var \KBO\StructType\ActivityFilterType
     */
    public $ActivityFilter;
    /**
     * The LocationFilter
     * @var \KBO\StructType\LocationFilterType
     */
    public $LocationFilter;
    /**
     * The EnterprisePhysicalPersonFilter
     * @var bool
     */
    public $EnterprisePhysicalPersonFilter;
    /**
     * The EnterpriseLegalPersonFilter
     * @var bool
     */
    public $EnterpriseLegalPersonFilter;
    /**
     * The EstablishmentFilter
     * @var bool
     */
    public $EstablishmentFilter;
    /**
     * The ActiveFilter
     * @var bool
     */
    public $ActiveFilter;
    /**
     * Constructor method for ReadEnterpriseOrEstablishmentByActivityRequestType
     * @uses ReadEnterpriseOrEstablishmentByActivityRequestType::setActivityFilter()
     * @uses ReadEnterpriseOrEstablishmentByActivityRequestType::setLocationFilter()
     * @uses ReadEnterpriseOrEstablishmentByActivityRequestType::setEnterprisePhysicalPersonFilter()
     * @uses ReadEnterpriseOrEstablishmentByActivityRequestType::setEnterpriseLegalPersonFilter()
     * @uses ReadEnterpriseOrEstablishmentByActivityRequestType::setEstablishmentFilter()
     * @uses ReadEnterpriseOrEstablishmentByActivityRequestType::setActiveFilter()
     * @param \KBO\StructType\ActivityFilterType $activityFilter
     * @param \KBO\StructType\LocationFilterType $locationFilter
     * @param bool $enterprisePhysicalPersonFilter
     * @param bool $enterpriseLegalPersonFilter
     * @param bool $establishmentFilter
     * @param bool $activeFilter
     */
    public function __construct(\KBO\StructType\ActivityFilterType $activityFilter = null, \KBO\StructType\LocationFilterType $locationFilter = null, $enterprisePhysicalPersonFilter = null, $enterpriseLegalPersonFilter = null, $establishmentFilter = null, $activeFilter = null)
    {
        $this
            ->setActivityFilter($activityFilter)
            ->setLocationFilter($locationFilter)
            ->setEnterprisePhysicalPersonFilter($enterprisePhysicalPersonFilter)
            ->setEnterpriseLegalPersonFilter($enterpriseLegalPersonFilter)
            ->setEstablishmentFilter($establishmentFilter)
            ->setActiveFilter($activeFilter);
    }
    /**
     * Get ActivityFilter value
     * @return \KBO\StructType\ActivityFilterType|null
     */
    public function getActivityFilter()
    {
        return $this->ActivityFilter;
    }
    /**
     * Set ActivityFilter value
     * @param \KBO\StructType\ActivityFilterType $activityFilter
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByActivityRequestType
     */
    public function setActivityFilter(\KBO\StructType\ActivityFilterType $activityFilter = null)
    {
        $this->ActivityFilter = $activityFilter;
        return $this;
    }
    /**
     * Get LocationFilter value
     * @return \KBO\StructType\LocationFilterType|null
     */
    public function getLocationFilter()
    {
        return $this->LocationFilter;
    }
    /**
     * Set LocationFilter value
     * @param \KBO\StructType\LocationFilterType $locationFilter
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByActivityRequestType
     */
    public function setLocationFilter(\KBO\StructType\LocationFilterType $locationFilter = null)
    {
        $this->LocationFilter = $locationFilter;
        return $this;
    }
    /**
     * Get EnterprisePhysicalPersonFilter value
     * @return bool|null
     */
    public function getEnterprisePhysicalPersonFilter()
    {
        return $this->EnterprisePhysicalPersonFilter;
    }
    /**
     * Set EnterprisePhysicalPersonFilter value
     * @param bool $enterprisePhysicalPersonFilter
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByActivityRequestType
     */
    public function setEnterprisePhysicalPersonFilter($enterprisePhysicalPersonFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($enterprisePhysicalPersonFilter) && !is_bool($enterprisePhysicalPersonFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enterprisePhysicalPersonFilter, true), gettype($enterprisePhysicalPersonFilter)), __LINE__);
        }
        $this->EnterprisePhysicalPersonFilter = $enterprisePhysicalPersonFilter;
        return $this;
    }
    /**
     * Get EnterpriseLegalPersonFilter value
     * @return bool|null
     */
    public function getEnterpriseLegalPersonFilter()
    {
        return $this->EnterpriseLegalPersonFilter;
    }
    /**
     * Set EnterpriseLegalPersonFilter value
     * @param bool $enterpriseLegalPersonFilter
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByActivityRequestType
     */
    public function setEnterpriseLegalPersonFilter($enterpriseLegalPersonFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($enterpriseLegalPersonFilter) && !is_bool($enterpriseLegalPersonFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enterpriseLegalPersonFilter, true), gettype($enterpriseLegalPersonFilter)), __LINE__);
        }
        $this->EnterpriseLegalPersonFilter = $enterpriseLegalPersonFilter;
        return $this;
    }
    /**
     * Get EstablishmentFilter value
     * @return bool|null
     */
    public function getEstablishmentFilter()
    {
        return $this->EstablishmentFilter;
    }
    /**
     * Set EstablishmentFilter value
     * @param bool $establishmentFilter
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByActivityRequestType
     */
    public function setEstablishmentFilter($establishmentFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($establishmentFilter) && !is_bool($establishmentFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($establishmentFilter, true), gettype($establishmentFilter)), __LINE__);
        }
        $this->EstablishmentFilter = $establishmentFilter;
        return $this;
    }
    /**
     * Get ActiveFilter value
     * @return bool|null
     */
    public function getActiveFilter()
    {
        return $this->ActiveFilter;
    }
    /**
     * Set ActiveFilter value
     * @param bool $activeFilter
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByActivityRequestType
     */
    public function setActiveFilter($activeFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeFilter) && !is_bool($activeFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeFilter, true), gettype($activeFilter)), __LINE__);
        }
        $this->ActiveFilter = $activeFilter;
        return $this;
    }
}
