<?php

namespace KBO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TypeOfAddressCodeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: There are five different types of addresses
 * @subpackage Enumerations
 */
class TypeOfAddressCodeType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'REGO'
     * Meta information extracted from the WSDL
     * - documentation: Address of an Registered Office
     * @return string 'REGO'
     */
    const VALUE_REGO = 'REGO';
    /**
     * Constant for value 'NOAD'
     * Meta information extracted from the WSDL
     * - documentation: No Adress
     * @return string 'NOAD'
     */
    const VALUE_NOAD = 'NOAD';
    /**
     * Constant for value 'BAET'
     * Meta information extracted from the WSDL
     * - documentation: Business Adress of an Establishment
     * @return string 'BAET'
     */
    const VALUE_BAET = 'BAET';
    /**
     * Constant for value 'ABBR'
     * Meta information extracted from the WSDL
     * - documentation: Adress of Belgian branch
     * @return string 'ABBR'
     */
    const VALUE_ABBR = 'ABBR';
    /**
     * Return allowed values
     * @uses self::VALUE_REGO
     * @uses self::VALUE_NOAD
     * @uses self::VALUE_BAET
     * @uses self::VALUE_ABBR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGO,
            self::VALUE_NOAD,
            self::VALUE_BAET,
            self::VALUE_ABBR,
        );
    }
}
