<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NeighboringMunicipalityLocationFilterType StructType
 * @subpackage Structs
 */
class NeighboringMunicipalityLocationFilterType extends AbstractStructBase
{
    /**
     * The MunicipalityCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 5
     * - pattern: \d{5}
     * @var string
     */
    public $MunicipalityCode;
    /**
     * Constructor method for NeighboringMunicipalityLocationFilterType
     * @uses NeighboringMunicipalityLocationFilterType::setMunicipalityCode()
     * @param string $municipalityCode
     */
    public function __construct($municipalityCode = null)
    {
        $this
            ->setMunicipalityCode($municipalityCode);
    }
    /**
     * Get MunicipalityCode value
     * @return string|null
     */
    public function getMunicipalityCode()
    {
        return $this->MunicipalityCode;
    }
    /**
     * Set MunicipalityCode value
     * @param string $municipalityCode
     * @return \KBO\StructType\NeighboringMunicipalityLocationFilterType
     */
    public function setMunicipalityCode($municipalityCode = null)
    {
        // validation for constraint: string
        if (!is_null($municipalityCode) && !is_string($municipalityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($municipalityCode, true), gettype($municipalityCode)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($municipalityCode) && mb_strlen($municipalityCode) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($municipalityCode)), __LINE__);
        }
        // validation for constraint: pattern(\d{5})
        if (!is_null($municipalityCode) && !preg_match('/\\d{5}/', $municipalityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{5}', var_export($municipalityCode, true)), __LINE__);
        }
        $this->MunicipalityCode = $municipalityCode;
        return $this;
    }
}
