<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinkedEnterpriseType StructType
 * @subpackage Structs
 */
class LinkedEnterpriseType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \KBO\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The EnterpriseNumberSubject
     * @var int
     */
    public $EnterpriseNumberSubject;
    /**
     * The EnterpriseNumberObject
     * @var int
     */
    public $EnterpriseNumberObject;
    /**
     * The Period
     * @var \KBO\StructType\PeriodType
     */
    public $Period;
    /**
     * Constructor method for LinkedEnterpriseType
     * @uses LinkedEnterpriseType::setCode()
     * @uses LinkedEnterpriseType::setDescription()
     * @uses LinkedEnterpriseType::setEnterpriseNumberSubject()
     * @uses LinkedEnterpriseType::setEnterpriseNumberObject()
     * @uses LinkedEnterpriseType::setPeriod()
     * @param string $code
     * @param \KBO\StructType\DescriptionType[] $description
     * @param int $enterpriseNumberSubject
     * @param int $enterpriseNumberObject
     * @param \KBO\StructType\PeriodType $period
     */
    public function __construct($code = null, array $description = array(), $enterpriseNumberSubject = null, $enterpriseNumberObject = null, \KBO\StructType\PeriodType $period = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setEnterpriseNumberSubject($enterpriseNumberSubject)
            ->setEnterpriseNumberObject($enterpriseNumberObject)
            ->setPeriod($period);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \KBO\StructType\LinkedEnterpriseType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return \KBO\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $linkedEnterpriseTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$linkedEnterpriseTypeDescriptionItem instanceof \KBO\StructType\DescriptionType) {
                $invalidValues[] = is_object($linkedEnterpriseTypeDescriptionItem) ? get_class($linkedEnterpriseTypeDescriptionItem) : sprintf('%s(%s)', gettype($linkedEnterpriseTypeDescriptionItem), var_export($linkedEnterpriseTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType[] $description
     * @return \KBO\StructType\LinkedEnterpriseType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType $item
     * @return \KBO\StructType\LinkedEnterpriseType
     */
    public function addToDescription(\KBO\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get EnterpriseNumberSubject value
     * @return int|null
     */
    public function getEnterpriseNumberSubject()
    {
        return $this->EnterpriseNumberSubject;
    }
    /**
     * Set EnterpriseNumberSubject value
     * @param int $enterpriseNumberSubject
     * @return \KBO\StructType\LinkedEnterpriseType
     */
    public function setEnterpriseNumberSubject($enterpriseNumberSubject = null)
    {
        // validation for constraint: int
        if (!is_null($enterpriseNumberSubject) && !(is_int($enterpriseNumberSubject) || ctype_digit($enterpriseNumberSubject))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enterpriseNumberSubject, true), gettype($enterpriseNumberSubject)), __LINE__);
        }
        $this->EnterpriseNumberSubject = $enterpriseNumberSubject;
        return $this;
    }
    /**
     * Get EnterpriseNumberObject value
     * @return int|null
     */
    public function getEnterpriseNumberObject()
    {
        return $this->EnterpriseNumberObject;
    }
    /**
     * Set EnterpriseNumberObject value
     * @param int $enterpriseNumberObject
     * @return \KBO\StructType\LinkedEnterpriseType
     */
    public function setEnterpriseNumberObject($enterpriseNumberObject = null)
    {
        // validation for constraint: int
        if (!is_null($enterpriseNumberObject) && !(is_int($enterpriseNumberObject) || ctype_digit($enterpriseNumberObject))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enterpriseNumberObject, true), gettype($enterpriseNumberObject)), __LINE__);
        }
        $this->EnterpriseNumberObject = $enterpriseNumberObject;
        return $this;
    }
    /**
     * Get Period value
     * @return \KBO\StructType\PeriodType|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \KBO\StructType\PeriodType $period
     * @return \KBO\StructType\LinkedEnterpriseType
     */
    public function setPeriod(\KBO\StructType\PeriodType $period = null)
    {
        $this->Period = $period;
        return $this;
    }
}
