<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadEstablishmentByEnterpriseNumberRequestType StructType
 * @subpackage Structs
 */
class ReadEstablishmentByEnterpriseNumberRequestType extends AbstractStructBase
{
    /**
     * The EnterpriseNumber
     * Meta information extracted from the WSDL
     * - base: xs:long
     * - pattern: [01]?[0-9]{9}
     * - ref: datamodel:EnterpriseNumber
     * @var int
     */
    public $EnterpriseNumber;
    /**
     * The TypeOfResult
     * @var string
     */
    public $TypeOfResult;
    /**
     * Constructor method for ReadEstablishmentByEnterpriseNumberRequestType
     * @uses ReadEstablishmentByEnterpriseNumberRequestType::setEnterpriseNumber()
     * @uses ReadEstablishmentByEnterpriseNumberRequestType::setTypeOfResult()
     * @param int $enterpriseNumber
     * @param string $typeOfResult
     */
    public function __construct($enterpriseNumber = null, $typeOfResult = null)
    {
        $this
            ->setEnterpriseNumber($enterpriseNumber)
            ->setTypeOfResult($typeOfResult);
    }
    /**
     * Get EnterpriseNumber value
     * @return int|null
     */
    public function getEnterpriseNumber()
    {
        return $this->EnterpriseNumber;
    }
    /**
     * Set EnterpriseNumber value
     * @param int $enterpriseNumber
     * @return \KBO\StructType\ReadEstablishmentByEnterpriseNumberRequestType
     */
    public function setEnterpriseNumber($enterpriseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($enterpriseNumber) && !(is_int($enterpriseNumber) || ctype_digit($enterpriseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enterpriseNumber, true), gettype($enterpriseNumber)), __LINE__);
        }
        // validation for constraint: pattern([01]?[0-9]{9})
        if (!is_null($enterpriseNumber) && !preg_match('/[01]?[0-9]{9}/', $enterpriseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [01]?[0-9]{9}', var_export($enterpriseNumber, true)), __LINE__);
        }
        $this->EnterpriseNumber = $enterpriseNumber;
        return $this;
    }
    /**
     * Get TypeOfResult value
     * @return string|null
     */
    public function getTypeOfResult()
    {
        return $this->TypeOfResult;
    }
    /**
     * Set TypeOfResult value
     * @uses \KBO\EnumType\RepresentationType::valueIsValid()
     * @uses \KBO\EnumType\RepresentationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfResult
     * @return \KBO\StructType\ReadEstablishmentByEnterpriseNumberRequestType
     */
    public function setTypeOfResult($typeOfResult = null)
    {
        // validation for constraint: enumeration
        if (!\KBO\EnumType\RepresentationType::valueIsValid($typeOfResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \KBO\EnumType\RepresentationType', is_array($typeOfResult) ? implode(', ', $typeOfResult) : var_export($typeOfResult, true), implode(', ', \KBO\EnumType\RepresentationType::getValidValues())), __LINE__);
        }
        $this->TypeOfResult = $typeOfResult;
        return $this;
    }
}
