<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadEnterpriseOrEstablishmentByAddressRequestType
 * StructType
 * @subpackage Structs
 */
class ReadEnterpriseOrEstablishmentByAddressRequestType extends AbstractStructBase
{
    /**
     * The Zipcode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 4
     * - pattern: \d{4}
     * @var string
     */
    public $Zipcode;
    /**
     * The StreetName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 2
     * @var string
     */
    public $StreetName;
    /**
     * The HouseNumber
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 11
     * - minLength: 1
     * @var string
     */
    public $HouseNumber;
    /**
     * The ActiveFilter
     * @var bool
     */
    public $ActiveFilter;
    /**
     * Constructor method for ReadEnterpriseOrEstablishmentByAddressRequestType
     * @uses ReadEnterpriseOrEstablishmentByAddressRequestType::setZipcode()
     * @uses ReadEnterpriseOrEstablishmentByAddressRequestType::setStreetName()
     * @uses ReadEnterpriseOrEstablishmentByAddressRequestType::setHouseNumber()
     * @uses ReadEnterpriseOrEstablishmentByAddressRequestType::setActiveFilter()
     * @param string $zipcode
     * @param string $streetName
     * @param string $houseNumber
     * @param bool $activeFilter
     */
    public function __construct($zipcode = null, $streetName = null, $houseNumber = null, $activeFilter = null)
    {
        $this
            ->setZipcode($zipcode)
            ->setStreetName($streetName)
            ->setHouseNumber($houseNumber)
            ->setActiveFilter($activeFilter);
    }
    /**
     * Get Zipcode value
     * @return string|null
     */
    public function getZipcode()
    {
        return $this->Zipcode;
    }
    /**
     * Set Zipcode value
     * @param string $zipcode
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByAddressRequestType
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($zipcode) && mb_strlen($zipcode) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($zipcode)), __LINE__);
        }
        // validation for constraint: pattern(\d{4})
        if (!is_null($zipcode) && !preg_match('/\\d{4}/', $zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}', var_export($zipcode, true)), __LINE__);
        }
        $this->Zipcode = $zipcode;
        return $this;
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByAddressRequestType
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($streetName) && mb_strlen($streetName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($streetName)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($streetName) && mb_strlen($streetName) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get HouseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->HouseNumber;
    }
    /**
     * Set HouseNumber value
     * @param string $houseNumber
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByAddressRequestType
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($houseNumber) && mb_strlen($houseNumber) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($houseNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($houseNumber) && mb_strlen($houseNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($houseNumber)), __LINE__);
        }
        $this->HouseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get ActiveFilter value
     * @return bool|null
     */
    public function getActiveFilter()
    {
        return $this->ActiveFilter;
    }
    /**
     * Set ActiveFilter value
     * @param bool $activeFilter
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByAddressRequestType
     */
    public function setActiveFilter($activeFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeFilter) && !is_bool($activeFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeFilter, true), gettype($activeFilter)), __LINE__);
        }
        $this->ActiveFilter = $activeFilter;
        return $this;
    }
}
