<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinancialDataType StructType
 * @subpackage Structs
 */
class FinancialDataType extends AbstractStructBase
{
    /**
     * The AnnualMeetingMonth
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxInclusive: 12
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnnualMeetingMonth;
    /**
     * The FiscalYearEndDay
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxInclusive: 31
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $FiscalYearEndDay;
    /**
     * The FiscalYearEndMonth
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxInclusive: 12
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $FiscalYearEndMonth;
    /**
     * The ExceptionalFiscalYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\PeriodType
     */
    public $ExceptionalFiscalYear;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\PeriodType
     */
    public $ValidityPeriod;
    /**
     * Constructor method for FinancialDataType
     * @uses FinancialDataType::setAnnualMeetingMonth()
     * @uses FinancialDataType::setFiscalYearEndDay()
     * @uses FinancialDataType::setFiscalYearEndMonth()
     * @uses FinancialDataType::setExceptionalFiscalYear()
     * @uses FinancialDataType::setValidityPeriod()
     * @param int $annualMeetingMonth
     * @param int $fiscalYearEndDay
     * @param int $fiscalYearEndMonth
     * @param \KBO\StructType\PeriodType $exceptionalFiscalYear
     * @param \KBO\StructType\PeriodType $validityPeriod
     */
    public function __construct($annualMeetingMonth = null, $fiscalYearEndDay = null, $fiscalYearEndMonth = null, \KBO\StructType\PeriodType $exceptionalFiscalYear = null, \KBO\StructType\PeriodType $validityPeriod = null)
    {
        $this
            ->setAnnualMeetingMonth($annualMeetingMonth)
            ->setFiscalYearEndDay($fiscalYearEndDay)
            ->setFiscalYearEndMonth($fiscalYearEndMonth)
            ->setExceptionalFiscalYear($exceptionalFiscalYear)
            ->setValidityPeriod($validityPeriod);
    }
    /**
     * Get AnnualMeetingMonth value
     * @return int|null
     */
    public function getAnnualMeetingMonth()
    {
        return $this->AnnualMeetingMonth;
    }
    /**
     * Set AnnualMeetingMonth value
     * @param int $annualMeetingMonth
     * @return \KBO\StructType\FinancialDataType
     */
    public function setAnnualMeetingMonth($annualMeetingMonth = null)
    {
        // validation for constraint: int
        if (!is_null($annualMeetingMonth) && !(is_int($annualMeetingMonth) || ctype_digit($annualMeetingMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($annualMeetingMonth, true), gettype($annualMeetingMonth)), __LINE__);
        }
        // validation for constraint: maxInclusive(12)
        if (!is_null($annualMeetingMonth) && $annualMeetingMonth > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 12', var_export($annualMeetingMonth, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($annualMeetingMonth) && $annualMeetingMonth < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($annualMeetingMonth, true)), __LINE__);
        }
        $this->AnnualMeetingMonth = $annualMeetingMonth;
        return $this;
    }
    /**
     * Get FiscalYearEndDay value
     * @return int|null
     */
    public function getFiscalYearEndDay()
    {
        return $this->FiscalYearEndDay;
    }
    /**
     * Set FiscalYearEndDay value
     * @param int $fiscalYearEndDay
     * @return \KBO\StructType\FinancialDataType
     */
    public function setFiscalYearEndDay($fiscalYearEndDay = null)
    {
        // validation for constraint: int
        if (!is_null($fiscalYearEndDay) && !(is_int($fiscalYearEndDay) || ctype_digit($fiscalYearEndDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fiscalYearEndDay, true), gettype($fiscalYearEndDay)), __LINE__);
        }
        // validation for constraint: maxInclusive(31)
        if (!is_null($fiscalYearEndDay) && $fiscalYearEndDay > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 31', var_export($fiscalYearEndDay, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($fiscalYearEndDay) && $fiscalYearEndDay < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($fiscalYearEndDay, true)), __LINE__);
        }
        $this->FiscalYearEndDay = $fiscalYearEndDay;
        return $this;
    }
    /**
     * Get FiscalYearEndMonth value
     * @return int|null
     */
    public function getFiscalYearEndMonth()
    {
        return $this->FiscalYearEndMonth;
    }
    /**
     * Set FiscalYearEndMonth value
     * @param int $fiscalYearEndMonth
     * @return \KBO\StructType\FinancialDataType
     */
    public function setFiscalYearEndMonth($fiscalYearEndMonth = null)
    {
        // validation for constraint: int
        if (!is_null($fiscalYearEndMonth) && !(is_int($fiscalYearEndMonth) || ctype_digit($fiscalYearEndMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fiscalYearEndMonth, true), gettype($fiscalYearEndMonth)), __LINE__);
        }
        // validation for constraint: maxInclusive(12)
        if (!is_null($fiscalYearEndMonth) && $fiscalYearEndMonth > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 12', var_export($fiscalYearEndMonth, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($fiscalYearEndMonth) && $fiscalYearEndMonth < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($fiscalYearEndMonth, true)), __LINE__);
        }
        $this->FiscalYearEndMonth = $fiscalYearEndMonth;
        return $this;
    }
    /**
     * Get ExceptionalFiscalYear value
     * @return \KBO\StructType\PeriodType|null
     */
    public function getExceptionalFiscalYear()
    {
        return $this->ExceptionalFiscalYear;
    }
    /**
     * Set ExceptionalFiscalYear value
     * @param \KBO\StructType\PeriodType $exceptionalFiscalYear
     * @return \KBO\StructType\FinancialDataType
     */
    public function setExceptionalFiscalYear(\KBO\StructType\PeriodType $exceptionalFiscalYear = null)
    {
        $this->ExceptionalFiscalYear = $exceptionalFiscalYear;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \KBO\StructType\PeriodType|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \KBO\StructType\PeriodType $validityPeriod
     * @return \KBO\StructType\FinancialDataType
     */
    public function setValidityPeriod(\KBO\StructType\PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
}
