<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadCodeListRequestType StructType
 * @subpackage Structs
 */
class ReadCodeListRequestType extends AbstractStructBase
{
    /**
     * The CodeListId
     * @var string
     */
    public $CodeListId;
    /**
     * Constructor method for ReadCodeListRequestType
     * @uses ReadCodeListRequestType::setCodeListId()
     * @param string $codeListId
     */
    public function __construct($codeListId = null)
    {
        $this
            ->setCodeListId($codeListId);
    }
    /**
     * Get CodeListId value
     * @return string|null
     */
    public function getCodeListId()
    {
        return $this->CodeListId;
    }
    /**
     * Set CodeListId value
     * @param string $codeListId
     * @return \KBO\StructType\ReadCodeListRequestType
     */
    public function setCodeListId($codeListId = null)
    {
        // validation for constraint: string
        if (!is_null($codeListId) && !is_string($codeListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeListId, true), gettype($codeListId)), __LINE__);
        }
        $this->CodeListId = $codeListId;
        return $this;
    }
}
