<?php

namespace KBO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for RepresentationType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Type of the representation of the requests
 * @subpackage Enumerations
 */
class RepresentationType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'short'
     * Meta information extracted from the WSDL
     * - documentation: Summary representation of a request
     * @return string 'short'
     */
    const VALUE_SHORT = 'short';
    /**
     * Constant for value 'long'
     * Meta information extracted from the WSDL
     * - documentation: Comprehensive representation of a request
     * @return string 'long'
     */
    const VALUE_LONG = 'long';
    /**
     * Return allowed values
     * @uses self::VALUE_SHORT
     * @uses self::VALUE_LONG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SHORT,
            self::VALUE_LONG,
        );
    }
}
